/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.settings;

import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.cms.clouddrives.settings.CloudDriveSettingsRestEntity;
import org.exoplatform.services.cms.clouddrives.settings.CloudDriveUserSettingsService;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudDriveUserSettingsServiceImpl
implements CloudDriveUserSettingsService {
    private SettingService settingService;
    private static final Scope CLOUD_DRIVE_USER_SETTING_SCOPE = Scope.APPLICATION.id("CloudDrive");
    private static final String CLOUD_DRIVE_SETTING_KEY = "CloudDriveSettings";

    public CloudDriveUserSettingsServiceImpl(SettingService settingService) {
        this.settingService = settingService;
    }

    @Override
    public void saveCloudDriveUserSettings(long userIdentityId, CloudDriveSettingsRestEntity cloudDriveSettingsRestEntity) {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("User identity id is mandatory");
        }
        if (cloudDriveSettingsRestEntity == null) {
            throw new IllegalArgumentException("CloudDrive user settings are empty");
        }
        SettingValue settingValue = this.settingService.get(Context.USER.id(String.valueOf(userIdentityId)), CLOUD_DRIVE_USER_SETTING_SCOPE, CLOUD_DRIVE_SETTING_KEY);
        JSONObject existingUserSettings = null;
        String jsonString = null;
        if (settingValue != null && settingValue.getValue() != null) {
            try {
                existingUserSettings = new JSONObject(settingValue.getValue().toString());
                jsonString = existingUserSettings.put(cloudDriveSettingsRestEntity.getConnector(), (Object)cloudDriveSettingsRestEntity.getAccount()).toString();
            }
            catch (JSONException e) {
                throw new IllegalStateException("Error while parsing to jsonObject", e);
            }
        }
        try {
            jsonString = new JSONObject().put(cloudDriveSettingsRestEntity.getConnector(), (Object)cloudDriveSettingsRestEntity.getAccount()).toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error creating json object", e);
        }
        this.settingService.set(Context.USER.id(String.valueOf(userIdentityId)), CLOUD_DRIVE_USER_SETTING_SCOPE, CLOUD_DRIVE_SETTING_KEY, SettingValue.create((String)jsonString));
    }

    @Override
    public String getCloudDriveUserSettings(long userIdentityId) {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("User identity id is mandatory");
        }
        SettingValue settingValue = this.settingService.get(Context.USER.id(String.valueOf(userIdentityId)), CLOUD_DRIVE_USER_SETTING_SCOPE, CLOUD_DRIVE_SETTING_KEY);
        return settingValue != null && settingValue.getValue() != null ? settingValue.getValue().toString() : "{}";
    }

    @Override
    public void deleteCloudDriveUserSettings(long identityId, String providerId) throws JSONException {
        SettingValue settingValue = this.settingService.get(Context.USER.id(String.valueOf(identityId)), CLOUD_DRIVE_USER_SETTING_SCOPE, CLOUD_DRIVE_SETTING_KEY);
        JSONObject existingUserSettings = new JSONObject(settingValue.getValue().toString());
        existingUserSettings.remove(providerId);
        this.settingService.set(Context.USER.id(String.valueOf(identityId)), CLOUD_DRIVE_USER_SETTING_SCOPE, CLOUD_DRIVE_SETTING_KEY, SettingValue.create((String)existingUserSettings.toString()));
    }
}

