/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.attachments.dao.AttachmentDAO;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.model.AttachmentContextEntity;
import org.exoplatform.services.attachments.storage.AttachmentStorage;
import org.exoplatform.services.attachments.utils.EntityBuilder;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class AttachmentStorageImpl
implements AttachmentStorage {
    AttachmentDAO attachmentDAO;
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private DocumentService documentService;
    private LinkManager linkManager;

    public AttachmentStorageImpl(AttachmentDAO attachmentDAO, RepositoryService repositoryService, SessionProviderService sessionProviderService, DocumentService documentService, LinkManager linkManager) {
        this.attachmentDAO = attachmentDAO;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.documentService = documentService;
        this.linkManager = linkManager;
    }

    @Override
    public void linkAttachmentToEntity(long entityId, String entityType, String attachmentId) {
        AttachmentContextEntity attachmentContextEntity = new AttachmentContextEntity();
        attachmentContextEntity.setEntityId(entityId);
        attachmentContextEntity.setEntityType(entityType.toUpperCase());
        attachmentContextEntity.setAttachmentId(attachmentId);
        attachmentContextEntity.setAttachedDate(System.currentTimeMillis());
        this.attachmentDAO.create(attachmentContextEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attachment> getAttachmentsByEntity(long entityId, String entityType) throws Exception {
        Session systemSession = Utils.getSystemSession(this.sessionProviderService, this.repositoryService);
        Session userSession = Utils.getSession(this.sessionProviderService, this.repositoryService);
        String workspace = Utils.getCurrentWorkspace(this.repositoryService);
        try {
            List<AttachmentContextEntity> attachmentsContextEntity = this.attachmentDAO.getAttachmentContextByEntity(entityId, entityType.toUpperCase());
            Utils.sortAttachmentsByDate(attachmentsContextEntity);
            List<Attachment> attachments = new ArrayList<Attachment>();
            if (!attachmentsContextEntity.isEmpty()) {
                for (AttachmentContextEntity attachmentContextEntity : attachmentsContextEntity) {
                    String attachmentId = attachmentContextEntity.getAttachmentId();
                    if (!this.checkAttachmentNodeExistence(systemSession, attachmentId) || Utils.isQuarantinedItem(systemSession, attachmentId)) continue;
                    Attachment attachment = EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, workspace, userSession, attachmentId);
                    attachments.add(attachment);
                }
                attachments = Utils.removeDuplicatedAttachments(userSession, attachments);
            }
            List list = attachments.stream().filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
            if (userSession != null) {
                userSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attachment getAttachmentItemByEntity(long entityId, String entityType, String attachmentId) throws Exception {
        Session session = Utils.getSession(this.sessionProviderService, this.repositoryService);
        try {
            AttachmentContextEntity attachmentEntity = this.attachmentDAO.getAttachmentItemByEntity(entityId, entityType.toUpperCase(), attachmentId);
            Attachment attachment = EntityBuilder.fromAttachmentNode(this.repositoryService, this.documentService, this.linkManager, Utils.getCurrentWorkspace(this.repositoryService), session, attachmentEntity.getAttachmentId());
            return attachment;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void deleteAllEntityAttachments(AttachmentContextEntity attachmentContextEntity) {
        this.attachmentDAO.delete(attachmentContextEntity);
    }

    @Override
    public void deleteAttachmentItemByIdByEntity(long entityId, String entityType, String attachmentId) {
        AttachmentContextEntity attachmentEntity = this.attachmentDAO.getAttachmentItemByEntity(entityId, entityType.toUpperCase(), attachmentId);
        this.attachmentDAO.delete(attachmentEntity);
    }

    private boolean checkAttachmentNodeExistence(Session session, String attachmentId) throws RepositoryException {
        try {
            ((ExtendedSession)session).getNodeByIdentifier(attachmentId);
        }
        catch (AccessDeniedException | ItemNotFoundException e) {
            return false;
        }
        return true;
    }
}

