/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cms.documents.DocumentEditor;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.DocumentUpdateActivityHandler;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.cms.documents.exception.PermissionValidationException;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class DocumentEditorProviderImpl
implements DocumentEditorProvider {
    private static final String DOCUMENTS_SCOPE_NAME = "documents".intern();
    private static final String EDITOR_ACTIVE_PATTERN = "documents.editors.%s.active".intern();
    private static final String EDITOR_PERMISSIONS_PATTERN = "documents.editors.%s.permissions".intern();
    protected boolean active;
    protected List<String> permissions;
    protected DocumentEditor editor;
    protected SettingService settingService;
    protected IdentityManager identityManager;
    protected OrganizationService organizationService;

    protected DocumentEditorProviderImpl(DocumentEditor editor, SettingService settingService, IdentityManager identityManager, OrganizationService organizationService) {
        this.editor = editor;
        this.settingService = settingService;
        this.identityManager = identityManager;
        this.organizationService = organizationService;
        Boolean storedActive = this.getStoredActive();
        List<String> storedPermissions = this.getStoredPermissions();
        if (storedActive != null && storedPermissions != null) {
            this.active = storedActive;
            this.permissions = storedPermissions;
        } else {
            this.active = editor.isActive();
            this.permissions = editor.getPermissions();
            this.storeActive();
            this.storePermissions();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void updateActive(boolean active) {
        this.active = active;
        this.storeActive();
    }

    @Override
    public List<String> getPermissions() {
        return Collections.unmodifiableList(this.permissions);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updatePermissions(List<String> permissions) throws PermissionValidationException {
        ArrayList<String> updatedPermissions = new ArrayList<String>();
        for (String string : permissions) {
            void var4_4;
            if (string != null && string.startsWith("/")) {
                String string2 = "*:" + string;
            }
            this.validatePermission((String)var4_4);
            updatedPermissions.add((String)var4_4);
        }
        this.permissions = updatedPermissions;
        this.storePermissions();
    }

    @Override
    public void beforeDocumentCreate(NewDocumentTemplate template, String parentPath, String title) throws Exception {
        this.editor.beforeDocumentCreate(template, parentPath, title);
    }

    @Override
    public void onDocumentCreated(String workspace, String path) throws Exception {
        this.editor.onDocumentCreated(workspace, path);
    }

    @Override
    public void initActivity(String uuid, String workspace, String activityId) throws Exception {
        this.editor.initActivity(uuid, workspace, activityId);
    }

    @Override
    public <T> T initPreview(String fileId, String workspace, URI requestURI, Locale locale) {
        return this.editor.initPreview(fileId, workspace, requestURI, locale);
    }

    @Override
    public String getProviderName() {
        return this.editor.getProviderName();
    }

    @Override
    public boolean isDocumentSupported(String fileId, String workspace) {
        return this.editor.isDocumentSupported(fileId, workspace);
    }

    @Override
    public DocumentUpdateActivityHandler getDocumentUpdateHandler() {
        return this.editor.getDocumentUpdateHandler();
    }

    @Override
    public void onLastEditorClosed(String fileId, String workspace) {
        this.editor.onLastEditorClosed(fileId, workspace);
    }

    @Override
    public long getEditingFinishedDelay() {
        return this.editor.getEditingFinishedDelay();
    }

    protected Boolean getStoredActive() {
        SettingValue activeParam = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(DOCUMENTS_SCOPE_NAME), String.format(EDITOR_ACTIVE_PATTERN, this.editor.getProviderName()));
        return activeParam != null ? Boolean.valueOf(activeParam.getValue().toString()) : null;
    }

    protected List<String> getStoredPermissions() {
        SettingValue permissionsParam = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(DOCUMENTS_SCOPE_NAME), String.format(EDITOR_PERMISSIONS_PATTERN, this.editor.getProviderName()));
        String permissionsStr = permissionsParam != null ? permissionsParam.getValue().toString() : null;
        return permissionsStr != null ? Arrays.asList(permissionsStr.split("\\s*,\\s*")) : null;
    }

    protected void storeActive() {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(DOCUMENTS_SCOPE_NAME), String.format(EDITOR_ACTIVE_PATTERN, this.editor.getProviderName()), SettingValue.create((Boolean)this.active));
    }

    protected void storePermissions() {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(DOCUMENTS_SCOPE_NAME), String.format(EDITOR_PERMISSIONS_PATTERN, this.editor.getProviderName()), SettingValue.create((String)String.join((CharSequence)",", this.permissions)));
    }

    protected void validatePermission(String permission) throws PermissionValidationException {
        if (permission == null) {
            throw new PermissionValidationException("The permission cannot be null");
        }
        String[] temp = permission.split(":");
        if (temp.length < 2) {
            String userId = temp[0];
            if (!userId.equals("*") && this.identityManager.getOrCreateIdentity("organization", userId) == null) {
                throw new PermissionValidationException("User " + userId + " doesn't exist.");
            }
        } else {
            String groupId = temp[1];
            Group group = null;
            try {
                group = this.organizationService.getGroupHandler().findGroupById(groupId);
            }
            catch (Exception e) {
                throw new PermissionValidationException("Cannot validate permission for group: " + String.valueOf(group) + ". " + e.getMessage());
            }
            if (group == null) {
                throw new PermissionValidationException("Group " + groupId + " doesn't exist.");
            }
        }
    }

    @Override
    public boolean isAvailableForUser(Identity identity) {
        if (this.isActive()) {
            UserACL userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
            for (String permission : this.permissions) {
                if (!permission.equals("*") && !permission.equals(identity.getUserId()) && !userACL.hasPermission(identity, permission)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<? extends DocumentEditor> getEditorClass() {
        return this.editor.getClass();
    }
}

