/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.cms.link.RangeIteratorLinkAware;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeIteratorLinkAware
extends RangeIteratorLinkAware
implements NodeIterator {
    private static final Log LOG = ExoLogger.getLogger((String)NodeIteratorLinkAware.class.getName());

    public NodeIteratorLinkAware(String originalWorkspace, String virtualPath, NodeIterator nodeIterator) {
        super(originalWorkspace, virtualPath, (RangeIterator)nodeIterator);
    }

    public Node nextNode() {
        Node node = (Node)this.iterator.next();
        try {
            return new NodeLinkAware(this.originalWorkspace, LinkUtils.createPath(this.virtualPath, node.getName() + (String)(node.getIndex() > 1 ? "[" + node.getIndex() + "]" : "")), node);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Cannot create an instance of NodeLinkAware", (Throwable)e);
            }
            return node;
        }
    }

    public Object next() {
        return this.nextNode();
    }
}

