/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.graphics.CalGray;
import org.icepdf.core.pobjects.graphics.CalRGB;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.Lab;
import org.icepdf.core.pobjects.graphics.PatternColor;
import org.icepdf.core.pobjects.graphics.Separation;
import org.icepdf.core.util.Library;

public abstract class PColorSpace
extends Dictionary {
    private static final Logger logger = Logger.getLogger(PColorSpace.class.toString());

    public abstract int getNumComponents();

    public String getDescription() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    PColorSpace(Library l, HashMap h) {
        super(l, h);
    }

    public static PColorSpace getColorSpace(Library library, Object o) {
        if (o != null) {
            PColorSpace colorSpace = null;
            Reference ref = null;
            if (o instanceof Reference) {
                ref = (Reference)o;
                o = library.getObject(ref);
            }
            if (o instanceof PColorSpace) {
                colorSpace = (PColorSpace)o;
            } else if (o instanceof Name) {
                if (o.equals(DeviceGray.DEVICEGRAY_KEY) || o.equals(DeviceGray.G_KEY)) {
                    colorSpace = new DeviceGray(library, null);
                } else if (o.equals(DeviceRGB.DEVICERGB_KEY) || o.equals(DeviceRGB.RGB_KEY)) {
                    colorSpace = new DeviceRGB(library, null);
                } else if (o.equals(DeviceCMYK.DEVICECMYK_KEY) || o.equals(DeviceCMYK.CMYK_KEY)) {
                    colorSpace = new DeviceCMYK(library, null);
                } else if (o.equals(PatternColor.PATTERN_KEY)) {
                    colorSpace = new PatternColor(library, null);
                }
            } else if (o instanceof List) {
                List v = (List)o;
                Name colorant = (Name)v.get(0);
                if (colorant.equals(Indexed.INDEXED_KEY) || colorant.equals(Indexed.I_KEY)) {
                    colorSpace = new Indexed(library, null, v);
                } else if (colorant.equals(CalRGB.CALRGB_KEY)) {
                    colorSpace = new CalRGB(library, PColorSpace.getHashMap(library, v.get(1)));
                } else if (colorant.equals(CalGray.CAL_GRAY_KEY)) {
                    colorSpace = new CalGray(library, PColorSpace.getHashMap(library, v.get(1)));
                } else if (colorant.equals(Lab.LAB_KEY)) {
                    colorSpace = new Lab(library, PColorSpace.getHashMap(library, v.get(1)));
                } else if (colorant.equals(Separation.SEPARATION_KEY)) {
                    colorSpace = new Separation(library, null, v.get(1), v.get(2), v.get(3));
                } else if (colorant.equals(DeviceN.DEVICEN_KEY)) {
                    colorSpace = new DeviceN(library, null, v.get(1), v.get(2), v.get(3), v.size() > 4 ? v.get(4) : null);
                } else if (colorant.equals(ICCBased.ICCBASED_KEY)) {
                    colorSpace = library.getICCBased((Reference)v.get(1));
                } else if (colorant.equals(DeviceRGB.DEVICERGB_KEY)) {
                    colorSpace = new DeviceRGB(library, null);
                } else if (colorant.equals(DeviceCMYK.DEVICECMYK_KEY)) {
                    colorSpace = new DeviceCMYK(library, null);
                } else if (colorant.equals(DeviceGray.DEVICEGRAY_KEY)) {
                    colorSpace = new DeviceGray(library, null);
                } else if (colorant.equals(PatternColor.PATTERN_KEY)) {
                    PatternColor patternColour = new PatternColor(library, null);
                    if (v.size() > 1) {
                        Object tmp = v.get(1);
                        if (tmp instanceof Reference) {
                            tmp = library.getObject((Reference)v.get(1));
                            if (tmp instanceof PColorSpace) {
                                patternColour.setPColorSpace((PColorSpace)tmp);
                            } else if (tmp instanceof HashMap) {
                                patternColour.setPColorSpace(PColorSpace.getColorSpace(library, tmp));
                            }
                        } else {
                            patternColour.setPColorSpace(PColorSpace.getColorSpace(library, PColorSpace.getHashMap(library, v.get(1))));
                        }
                    }
                    colorSpace = patternColour;
                }
            } else if (o instanceof HashMap) {
                colorSpace = new PatternColor(library, (HashMap)o);
            }
            if (colorSpace == null && logger.isLoggable(Level.FINE)) {
                logger.fine("Unsupported ColorSpace: " + o);
            }
            if (ref != null && colorSpace != null) {
                library.addObject(colorSpace, ref);
            }
            if (colorSpace != null) {
                return colorSpace;
            }
        }
        return new DeviceGray(library, null);
    }

    private static HashMap getHashMap(Library library, Object obj) {
        HashMap entries = null;
        if (obj instanceof HashMap) {
            entries = (HashMap)obj;
        } else if (obj instanceof Reference && (obj = library.getObject((Reference)obj)) instanceof HashMap) {
            entries = (HashMap)obj;
        }
        return entries;
    }

    public static synchronized PColorSpace getColorSpace(Library library, float n) {
        if (n == 3.0f) {
            return new DeviceRGB(library, null);
        }
        if (n == 4.0f) {
            return new DeviceCMYK(library, null);
        }
        return new DeviceGray(library, null);
    }

    public Color getColor(float[] components) {
        return this.getColor(components, false);
    }

    public abstract Color getColor(float[] var1, boolean var2);

    public void normaliseComponentsToFloats(int[] in, float[] out, float maxval) {
        int count = this.getNumComponents();
        for (int i = 0; i < count; ++i) {
            out[i] = (float)in[i] / maxval;
        }
    }

    public static float[] reverse(float[] f) {
        float[] n = new float[f.length];
        for (int i = 0; i < f.length; ++i) {
            n[i] = f[f.length - i - 1];
        }
        return n;
    }

    public static void reverseInPlace(float[] f) {
        int num = f.length / 2;
        for (int i = 0; i < num; ++i) {
            float tmp = f[i];
            f[i] = f[f.length - 1 - i];
            f[f.length - 1 - i] = tmp;
        }
    }

    public static void reverseInPlace(int[] f) {
        int num = f.length / 2;
        for (int i = 0; i < num; ++i) {
            int tmp = f[i];
            f[i] = f[f.length - 1 - i];
            f[f.length - 1 - i] = tmp;
        }
    }
}

