/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.Utils;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.plugin.doc.NodePresentation;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;

public abstract class UIBaseNodePresentation
extends UIContainer
implements NodePresentation {
    private String language_;
    private String mediaState = "NONE";
    private static final Log LOG = ExoLogger.getLogger((String)UIBaseNodePresentation.class.getName());

    @Override
    public abstract Node getNode() throws Exception;

    @Override
    public abstract Node getOriginalNode() throws Exception;

    public String getRepositoryName() throws Exception {
        return WCMCoreUtils.getRepository().getConfiguration().getName();
    }

    @Override
    public String encodeHTML(String text) throws Exception {
        return Utils.encodeHTML((String)text);
    }

    @Override
    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return "";
    }

    @Override
    public Object getComponentInstanceOfType(String className) {
        Object service;
        block2: {
            service = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> object = loader.loadClass(className);
                service = this.getApplicationComponent(object);
            }
            catch (ClassNotFoundException ex) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)ex);
            }
        }
        return service;
    }

    @Override
    public String getDownloadLink(Node node) throws Exception {
        return Utils.getDownloadLink((Node)node);
    }

    @Override
    public String getIcons(Node node, String size) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)size);
    }

    @Override
    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    @Override
    public String getLanguage() {
        return this.language_;
    }

    @Override
    public void setLanguage(String language) {
        this.language_ = language;
    }

    @Override
    public String getPortalName() {
        PortalContainerInfo containerInfo = (PortalContainerInfo)WCMCoreUtils.getService(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    @Override
    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.getNode().hasProperty("exo:relation")) {
            Value[] vals = this.getNode().getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    @Override
    public String getRepository() throws Exception {
        return ((ManageableRepository)this.getNode().getSession().getRepository()).getConfiguration().getName();
    }

    public boolean isFastPublishLink() {
        return false;
    }

    @Override
    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    @Override
    public String getWorkspaceName() throws Exception {
        return this.getNode().getSession().getWorkspace().getName();
    }

    public Node getNodeByUUID(String uuid) {
        ManageableRepository manageRepo = WCMCoreUtils.getRepository();
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider provider = WCMCoreUtils.getSystemSessionProvider();
        for (String ws : workspaces) {
            try {
                return provider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return null;
    }

    public String getImageURIInProperty(Node node, String propertyName) throws Exception {
        try {
            InputStream input = node.getProperty(propertyName).getStream();
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
            dresource.setDownloadName(node.getName());
            DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPortletPreferenceValue(String preferenceName) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (requestContext instanceof PortletRequestContext) {
            PortletRequestContext context = (PortletRequestContext)PortletRequestContext.class.cast(requestContext);
            return context.getRequest().getPreferences().getValue(preferenceName, null);
        }
        return null;
    }

    public String[] getPortletPreferenceValues(String preferenceName) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (requestContext instanceof PortletRequestContext) {
            PortletRequestContext context = (PortletRequestContext)PortletRequestContext.class.cast(requestContext);
            return context.getRequest().getPreferences().getValues(preferenceName, null);
        }
        return null;
    }

    @Override
    public String getMediaState() {
        return this.mediaState;
    }

    @Override
    public void switchMediaState() {
        this.mediaState = "DISPLAY".equals(this.mediaState) ? "NONE" : "DISPLAY";
    }

    @Override
    public boolean isDisplayAlternativeText() {
        return false;
    }

    @Override
    public boolean playAudioDescription() {
        return false;
    }

    @Override
    public boolean switchBackAudioDescription() {
        return false;
    }

    @Override
    public String getActionOpenDocInDesktop() throws Exception {
        return null;
    }

    public String getRelativeTimeLabel(WebuiBindingContext webuiBindingContext, Date postedTime) {
        Locale locale = webuiBindingContext.getRequestContext().getLocale();
        long postedTimeLong = postedTime.getTime();
        return DateUtils.getRelativeTimeLabel((Locale)locale, (long)postedTimeLong);
    }
}

