/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIShareDocuments;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIWhoHasAccessEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="war:/groovy/ecm/social-integration/share-document/UIWhoHasAccess.gtmpl")
public class UIWhoHasAccess
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIWhoHasAccess.class);
    private static final String SPACE_PREFIX1 = "space::";
    private static final String SPACE_PREFIX2 = "*:/spaces/";
    private static final String GROUP_PREFIX = "*:/";

    public void close() {
        for (UIComponent uicomp : this.getChildren()) {
            this.removeChild(UIWhoHasAccessEntry.class);
        }
    }

    public void init() {
        UIShareDocuments uishareDocuments = (UIShareDocuments)this.getAncestorOfType(UIShareDocuments.class);
        for (String id : uishareDocuments.getAllPermissions().keySet()) {
            try {
                User user;
                if (IdentityConstants.ANY.equals(id) || IdentityConstants.SYSTEM.equals(id) || id.contains(":/") && !this.isSpace(id) || !this.isSpace(id) && (user = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getUserHandler().findUserByName(id)) == null) continue;
                UIWhoHasAccessEntry uiWhoHasAccessEntry = (UIWhoHasAccessEntry)this.getChildById(id);
                if (uiWhoHasAccessEntry == null) {
                    uiWhoHasAccessEntry = (UIWhoHasAccessEntry)this.addChild(UIWhoHasAccessEntry.class, null, id);
                }
                uiWhoHasAccessEntry.init(id, uishareDocuments.getPermission(id));
            }
            catch (Exception e) {
                LOG.error((Object)("Error initializing Share documents permission entry for id = " + id), (Throwable)e);
            }
        }
    }

    public void update(String name, String permission) {
        block3: {
            try {
                if (this.getChildById(name) == null) {
                    this.addChild(UIWhoHasAccessEntry.class, null, name);
                }
                UIWhoHasAccessEntry uiWhoHasAccessEntry = (UIWhoHasAccessEntry)this.getChildById(name);
                uiWhoHasAccessEntry.init(name, permission);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void removeEntry(String id) {
        block2: {
            try {
                this.removeChildById(id);
                UIShareDocuments uiShareDocuments = (UIShareDocuments)this.getParent();
                uiShareDocuments.removePermission(id);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateEntry(String id, String permission) {
        block2: {
            try {
                UIShareDocuments uiShareDocuments = (UIShareDocuments)this.getParent();
                uiShareDocuments.updatePermission(id, permission);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getProfileUrl(String name) {
        return CommonsUtils.getCurrentDomain() + LinkProvider.getProfileUri((String)name);
    }

    private boolean isSpace(String name) {
        return name.startsWith(SPACE_PREFIX1) || name.startsWith(SPACE_PREFIX2);
    }

    public String getUserFullName(String name) throws Exception {
        String userFullName = name;
        User user = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getUserHandler().findUserByName(name);
        if (user != null) {
            userFullName = user.getDisplayName();
        }
        return userFullName;
    }

    public String getPrettySpaceName(String name) {
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        if (name.startsWith(SPACE_PREFIX1)) {
            return spaceService.getSpaceByPrettyName(name.substring(SPACE_PREFIX1.length())).getDisplayName();
        }
        return spaceService.getSpaceByPrettyName(name.substring(SPACE_PREFIX2.length())).getDisplayName();
    }

    public String getSpaceUrl(String name) {
        String space = name.startsWith(SPACE_PREFIX1) ? name.substring(SPACE_PREFIX1.length()) : name.substring(SPACE_PREFIX2.length());
        return CommonsUtils.getCurrentDomain() + LinkProvider.getSpaceUri((String)space.replace(" ", "_"));
    }

    public String getAvatar(String name) {
        try {
            if (this.isSpace(name)) {
                SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                Space space = name.startsWith(SPACE_PREFIX1) ? spaceService.getSpaceByPrettyName(name.substring(SPACE_PREFIX1.length())) : spaceService.getSpaceByPrettyName(name.substring(SPACE_PREFIX2.length()));
                return space.getAvatarUrl() != null ? space.getAvatarUrl() : "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
            }
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", name, true);
            Profile profile = identity.getProfile();
            return profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
        }
        catch (Exception e) {
            return "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
        }
    }

    public String getDisplayName(String name) {
        String displayName = name;
        try {
            displayName = this.isSpace(name) ? this.getPrettySpaceName(name) : this.getUserFullName(name);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot display name for entry " + name + " : " + e.getMessage()), (Throwable)e);
        }
        return displayName;
    }

    public String getEntryURL(String name) {
        String url = null;
        try {
            url = this.isSpace(name) ? this.getSpaceUrl(name) : this.getProfileUrl(name);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot URL for entry " + name + " : " + e.getMessage()), (Throwable)e);
        }
        return url;
    }

    public String getPrettyGroupName(String name) {
        return name.split(":")[1];
    }
}

