/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.Property;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class UtilsTest {
    @Mock
    ActivityManager activityManager;
    @Mock
    IdentityManager identityManager;
    @Mock
    ActivityCommonService activityCommonService;
    @Mock
    SpaceService spaceService;
    MockedStatic<CommonsUtils> COMMONS_UTILS;
    MockedStatic<Utils> UTILS;

    @Before
    public void setUp() throws Exception {
        this.COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
        this.UTILS = Mockito.mockStatic(Utils.class);
        this.COMMONS_UTILS.when(() -> this.activityManager.isActivityTypeEnabled((String)Mockito.nullable(String.class))).thenReturn((Object)true);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.eq(ActivityManager.class)))).thenReturn((Object)this.activityManager);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.eq(IdentityManager.class)))).thenReturn((Object)this.identityManager);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.eq(ActivityCommonService.class)))).thenReturn((Object)this.activityCommonService);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.eq(SpaceService.class)))).thenReturn((Object)this.spaceService);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId((String)Mockito.nullable(String.class))).thenReturn((Object)new Space());
        this.UTILS.when(() -> Utils.postFileActivity((Node)((Node)Mockito.any()), (String)((String)Mockito.nullable(String.class)), (boolean)Mockito.anyBoolean(), (boolean)Mockito.anyBoolean(), (String)((String)Mockito.nullable(String.class)), (String)((String)Mockito.nullable(String.class)))).thenCallRealMethod();
        this.UTILS.when(() -> Utils.getActivityOwnerId((Node)((Node)Mockito.any()))).thenReturn((Object)"john");
        this.UTILS.when(() -> Utils.isPublic((Node)((Node)Mockito.any()))).thenCallRealMethod();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId("123");
        this.UTILS.when(() -> Utils.createActivity((IdentityManager)((IdentityManager)Mockito.any()), (String)((String)Mockito.nullable(String.class)), (Node)((Node)Mockito.any()), (String)((String)Mockito.nullable(String.class)), (String)((String)Mockito.nullable(String.class)), (boolean)Mockito.anyBoolean(), (String)((String)Mockito.nullable(String.class)), (String)((String)Mockito.nullable(String.class)))).thenReturn((Object)activity);
        Mockito.when((Object)this.activityManager.getActivity(Mockito.anyString())).thenReturn((Object)activity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"organization"), (String)Mockito.any())).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity());
    }

    @After
    public void tearDown() throws Exception {
        this.COMMONS_UTILS.close();
        this.UTILS.close();
    }

    @Test
    public void shouldPostFileActivityWhenFileIsPublic() throws Exception {
        ExtendedNode node = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)node.isCheckedOut()).thenReturn((Object)true);
        Mockito.when((Object)node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)false);
        Mockito.when((Object)node.canAddMixin(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)).thenReturn((Object)false);
        AccessControlList acl = new AccessControlList("john", Arrays.asList(new AccessControlEntry("any", "read")));
        Mockito.when((Object)node.getACL()).thenReturn((Object)acl);
        Utils.postFileActivity((Node)node, null, (boolean)false, (boolean)false, (String)"", (String)"");
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).saveActivityNoReturn((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ExoSocialActivity)Mockito.any(ExoSocialActivity.class));
    }

    @Test
    public void shouldNotPostFileActivityWhenFileIsNotPublic() throws Exception {
        ExtendedNode node = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)node.isCheckedOut()).thenReturn((Object)true);
        Mockito.when((Object)node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)false);
        Mockito.lenient().when((Object)node.canAddMixin(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)).thenReturn((Object)false);
        AccessControlList acl = new AccessControlList("john", Arrays.asList(new AccessControlEntry("*:/spaces/space1", "read")));
        Mockito.when((Object)node.getACL()).thenReturn((Object)acl);
        ExoSocialActivity activity = Utils.postFileActivity((Node)node, null, (boolean)false, (boolean)false, (String)"", (String)"");
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.never())).saveActivityNoReturn((org.exoplatform.social.core.identity.model.Identity)Mockito.any(), (ExoSocialActivity)Mockito.any(ExoSocialActivity.class));
    }

    @Test
    public void checkPostActivityIfActivityTypeIsEnabled() throws Exception {
        ExtendedNode node = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)node.isCheckedOut()).thenReturn((Object)true);
        Mockito.when((Object)node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)false);
        Mockito.when((Object)node.canAddMixin(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)).thenReturn((Object)false);
        AccessControlList acl = new AccessControlList("john", Arrays.asList(new AccessControlEntry("any", "read")));
        Mockito.when((Object)node.getACL()).thenReturn((Object)acl);
        ActivityManager activityManager = (ActivityManager)Mockito.mock(ActivityManager.class);
        Mockito.when((Object)activityManager.isActivityTypeEnabled((String)Mockito.nullable(String.class))).thenReturn((Object)true);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.eq(ActivityManager.class)))).thenReturn((Object)activityManager);
        Utils.postFileActivity((Node)node, null, (boolean)false, (boolean)false, (String)"", (String)"");
        ((ActivityManager)Mockito.verify((Object)activityManager, (VerificationMode)Mockito.times((int)1))).saveActivityNoReturn((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ExoSocialActivity)Mockito.any(ExoSocialActivity.class));
        Mockito.lenient().when((Object)activityManager.isActivityTypeEnabled((String)Mockito.nullable(String.class))).thenReturn((Object)true);
        Utils.postActivity((Node)node, null, (boolean)false, (boolean)false, (String)"", (String)"");
        ((ActivityManager)Mockito.verify((Object)activityManager, (VerificationMode)Mockito.times((int)1))).saveActivityNoReturn((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ExoSocialActivity)Mockito.any(ExoSocialActivity.class));
    }

    @Test
    public void checkPostActivityIfActivityTypeIsDisabled() throws Exception {
        ExtendedNode node = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)node.isCheckedOut()).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)false);
        Mockito.lenient().when((Object)node.canAddMixin(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)).thenReturn((Object)false);
        AccessControlList acl = new AccessControlList("john", Arrays.asList(new AccessControlEntry("any", "read")));
        Mockito.lenient().when((Object)node.getACL()).thenReturn((Object)acl);
        ActivityManager activityManager = (ActivityManager)Mockito.mock(ActivityManager.class);
        Mockito.when((Object)activityManager.isActivityTypeEnabled((String)Mockito.nullable(String.class))).thenReturn((Object)false);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.eq(ActivityManager.class)))).thenReturn((Object)activityManager);
        Utils.postFileActivity((Node)node, null, (boolean)false, (boolean)false, (String)"", (String)"");
        ((ActivityManager)Mockito.verify((Object)activityManager, (VerificationMode)Mockito.never())).saveActivityNoReturn((org.exoplatform.social.core.identity.model.Identity)Mockito.any(), (ExoSocialActivity)Mockito.any(ExoSocialActivity.class));
        Utils.postActivity((Node)node, null, (boolean)false, (boolean)false, (String)"", (String)"");
        ((ActivityManager)Mockito.verify((Object)activityManager, (VerificationMode)Mockito.never())).saveActivityNoReturn((org.exoplatform.social.core.identity.model.Identity)Mockito.any(), (ExoSocialActivity)Mockito.any(ExoSocialActivity.class));
    }

    @Test
    public void testAddVersionComment() {
        this.UTILS.when(() -> Utils.addVersionComment((Node)((Node)Mockito.any(Node.class)), (String)Mockito.anyString(), (String)Mockito.anyString())).thenCallRealMethod();
        this.UTILS.when(() -> Utils.getSpaceName((Node)((Node)Mockito.any()))).thenReturn((Object)"/spaces/spaceOne");
        ConversationState conversionState = ConversationState.getCurrent();
        if (conversionState == null) {
            conversionState = new ConversationState(new Identity("root"));
            ConversationState.setCurrent((ConversationState)conversionState);
        }
        Node node = (Node)Mockito.mock(Node.class);
        String commentText = "this is a comment";
        String userName = "root";
        try {
            Mockito.when((Object)node.isCheckedOut()).thenReturn((Object)true);
            Mockito.when((Object)node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)false);
            Mockito.when((Object)node.canAddMixin(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)true);
            Mockito.lenient().when((Object)node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)).thenReturn((Object)false);
            Utils.addVersionComment((Node)node, (String)commentText, (String)userName);
            ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).saveComment((ExoSocialActivity)Mockito.any(), (ExoSocialActivity)Mockito.any());
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            Mockito.when((Object)node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)).thenReturn((Object)true);
            Property property = (Property)Mockito.mock(Property.class);
            Mockito.when((Object)property.getString()).thenReturn((Object)"444");
            Mockito.when((Object)node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)).thenReturn((Object)property);
            Mockito.when((Object)this.activityManager.getActivity((String)Mockito.eq((Object)"444"))).thenReturn(null);
            Mockito.lenient().when((Object)node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)).thenReturn((Object)true);
            Utils.addVersionComment((Node)node, (String)commentText, (String)userName);
            ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)2))).saveComment((ExoSocialActivity)Mockito.any(), (ExoSocialActivity)Mockito.any());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

