/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class TagActivityListener
extends Listener<Node, String> {
    private static String TAG_ADDED_BUNDLE = "SocialIntegration.messages.tagAdded";
    private static String TAG_REMOVED_BUNDLE = "SocialIntegration.messages.tagRemoved";
    private static String TAGS_ADDED_BUNDLE = "SocialIntegration.messages.tagsAdded";
    private static String TAGS_REMOVED_BUNDLE = "SocialIntegration.messages.tagsRemoved";
    private static String DOCUMENT_TAG_REMOVED = "Document.event.TagRemoved";
    private static String DOCUMENT_TAG_ADDED = "Document.event.TagAdded";
    private static final String TAG_ACTION_COMMENT = "files:spaces.TAG_ACTION_COMMENT";

    public void onEvent(Event<Node, String> event) throws Exception {
        boolean isMultiple;
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        String eventName = event.getEventName();
        if (!eventName.equals(DOCUMENT_TAG_ADDED) && !eventName.equals(DOCUMENT_TAG_REMOVED) || !activityManager.isActivityTypeEnabled(TAG_ACTION_COMMENT)) {
            return;
        }
        Node currentNode = (Node)event.getSource();
        String tagValue = (String)event.getData();
        int tagSepIndex = tagValue.indexOf(",");
        boolean bl = isMultiple = tagSepIndex > 0 && !tagValue.endsWith(",");
        String bundleMessage = isMultiple ? (DOCUMENT_TAG_ADDED.equals(eventName) ? TAGS_ADDED_BUNDLE : TAGS_REMOVED_BUNDLE) : (DOCUMENT_TAG_ADDED.equals(eventName) ? TAG_ADDED_BUNDLE : TAG_REMOVED_BUNDLE);
        Utils.postActivity(currentNode, bundleMessage, false, true, tagValue, "");
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        List links = linkManager.getAllLinks(currentNode, "exo:symlink");
        for (Node link : links) {
            ExoSocialActivity linkTagActivity;
            if (!link.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO) || (linkTagActivity = Utils.postActivity(link, bundleMessage, false, true, tagValue, "")) == null) continue;
            ActivityTypeUtils.attachActivityId((Node)link, (String)linkTagActivity.getId());
        }
    }
}

