/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.plugin.task;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.attachments.plugin.AttachmentACLPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;

public class TaskAttachmentACLPlugin
extends AttachmentACLPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)TaskAttachmentACLPlugin.class.getName());
    private static final String TASK_ATTACHMENT_TYPE = "task";
    private TaskService taskService;

    public TaskAttachmentACLPlugin(TaskService taskService) {
        this.taskService = taskService;
    }

    public String getEntityType() {
        return TASK_ATTACHMENT_TYPE;
    }

    public boolean canView(long userIdentityId, String entityType, String entityId) {
        return this.isProjectParticipant(userIdentityId, entityType, entityId);
    }

    public boolean canEdit(long userIdentityId, String entityType, String entityId) {
        return this.isProjectParticipant(userIdentityId, entityType, entityId);
    }

    public boolean canDetach(long userIdentityId, String entityType, String entityId) {
        return this.isProjectParticipant(userIdentityId, entityType, entityId);
    }

    private boolean isProjectParticipant(long userIdentityId, String entityType, String entityId) {
        if (!entityType.equals(TASK_ATTACHMENT_TYPE)) {
            throw new IllegalArgumentException("Entity type must betask");
        }
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            throw new IllegalArgumentException("Entity id must not be Empty");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("User identity must be positive");
        }
        boolean isParticipant = false;
        try {
            TaskDto task = this.taskService.getTask(Long.parseLong(entityId));
            isParticipant = TaskUtil.hasEditPermission((TaskService)this.taskService, (TaskDto)task);
        }
        catch (EntityNotFoundException e) {
            LOG.error((Object)("Can not find task with ID: " + entityId));
        }
        return isParticipant;
    }
}

