/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.plugins;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.nodetype.NodeType;
import junit.framework.TestCase;
import org.exoplatform.services.attachments.plugins.TaskAttachmentEntityTypePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TaskAttachmentEntityTypePluginTest
extends TestCase {
    public void testGetAttachmentOrLinkId() throws Exception {
        long entityId = 1L;
        TaskService taskService = (TaskService)Mockito.mock(TaskService.class);
        ProjectService projectService = (ProjectService)Mockito.mock(ProjectService.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)Mockito.mock(NodeHierarchyCreator.class);
        RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
        SessionProviderService sessionProviderService = (SessionProviderService)Mockito.mock(SessionProviderService.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        Mockito.when((Object)sessionProviderService.getSessionProvider(null)).thenReturn((Object)sessionProvider);
        ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)repositoryService.getCurrentRepository()).thenReturn((Object)repository);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        Mockito.when((Object)repository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repository.getConfiguration().getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        ExtendedSession extendedSession = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        Mockito.when((Object)sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)extendedSession);
        TaskDto task = new TaskDto();
        task.setId(1L);
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        StatusDto status = new StatusDto();
        status.setProject(project);
        task.setStatus(status);
        Mockito.when((Object)taskService.getTask(1L)).thenReturn((Object)task);
        Mockito.when((Object)projectService.getParticipator(ArgumentMatchers.anyLong())).thenReturn(new HashSet<String>(Arrays.asList("user1", "/platform/users", "member:/spaces/space1")));
        TaskAttachmentEntityTypePlugin taskAttachmentEntityTypePlugin = new TaskAttachmentEntityTypePlugin(taskService, projectService, nodeHierarchyCreator, sessionProviderService, repositoryService);
        String attachmentId = "123456789Azerty";
        String attachmentName = "testFile.docx";
        TaskAttachmentEntityTypePluginTest.assertEquals((int)1, (int)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", entityId, attachmentId).size());
        TaskAttachmentEntityTypePluginTest.assertEquals((String)attachmentId, (String)((String)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", entityId, attachmentId).get(0)));
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)node.getIdentifier()).thenReturn((Object)attachmentId);
        Mockito.when((Object)node.getName()).thenReturn((Object)attachmentName);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)extendedSession.getNodeByIdentifier(ArgumentMatchers.anyString())).thenReturn((Object)node);
        Mockito.when((Object)extendedSession.itemExists(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/Users/user1/documents/testFile.docx");
        TaskAttachmentEntityTypePluginTest.assertEquals((int)1, (int)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", 1L, attachmentId).size());
        TaskAttachmentEntityTypePluginTest.assertEquals((String)attachmentId, (String)((String)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", 1L, attachmentId).get(0)));
        NodeImpl rootNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl taskParentNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl taskNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl linkNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        String linkNodeIdentifier = "link_identifier_123456789Azerty";
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        WorkspaceImpl workspace = (WorkspaceImpl)Mockito.mock(WorkspaceImpl.class);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/Groups/spaces/spaceOne/documents/testFile.docx");
        Mockito.when((Object)linkNode.getIdentifier()).thenReturn((Object)linkNodeIdentifier);
        Mockito.when((Object)taskNode.addNode(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)linkNode);
        Mockito.when((Object)taskParentNode.getNode(String.valueOf(ArgumentMatchers.anyLong()))).thenReturn((Object)taskNode);
        Mockito.when((Object)taskParentNode.addNode(String.valueOf(entityId), "nt:folder")).thenReturn((Object)taskNode);
        Mockito.when((Object)rootNode.addNode("task", "nt:folder")).thenReturn((Object)taskParentNode);
        Mockito.when((Object)extendedSession.getItem(ArgumentMatchers.anyString())).thenReturn((Object)rootNode);
        TaskAttachmentEntityTypePluginTest.assertEquals((int)1, (int)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", 1L, attachmentId).size());
        TaskAttachmentEntityTypePluginTest.assertEquals((String)linkNodeIdentifier, (String)((String)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", 1L, attachmentId).get(0)));
        Mockito.when((Object)projectService.getParticipator(ArgumentMatchers.anyLong())).thenReturn(new HashSet<String>(Arrays.asList("user1", "/platform/users", "member:/spaces/space1", "member:/spaces/spaceOne")));
        TaskAttachmentEntityTypePluginTest.assertEquals((int)2, (int)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", 1L, attachmentId).size());
        TaskAttachmentEntityTypePluginTest.assertTrue((boolean)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", 1L, attachmentId).contains(attachmentId));
        TaskAttachmentEntityTypePluginTest.assertTrue((boolean)taskAttachmentEntityTypePlugin.getlinkedAttachments("task", 1L, attachmentId).contains(linkNodeIdentifier));
    }
}

