/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.test.mock;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/mock")
public class MockRestService
implements ResourceContainer {
    private List<String> guests = new ArrayList<String>();
    private final CacheControl cc = new CacheControl();

    public MockRestService() {
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @GET
    @Path(value="/guest")
    @Produces(value={"application/xhtml+xml"})
    public Response getGuest(@QueryParam(value="name") @DefaultValue(value="anonymous") String name) {
        if (!this.guests.contains(name)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)("Hello " + name), (String)"application/xhtml+xml").cacheControl(this.cc).build();
    }

    @POST
    @Path(value="/guest")
    @Produces(value={"application/json"})
    public Response register(@FormParam(value="name") @DefaultValue(value="anonymous") String name) {
        this.guests.add(name);
        return Response.ok((Object)("Registed " + name), (String)"application/json").cacheControl(this.cc).build();
    }

    @DELETE
    @Path(value="/guest")
    @Produces(value={"text/plain"})
    public Response remove(@QueryParam(value="name") @DefaultValue(value="anonymous") String name) {
        if (!this.guests.contains(name)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.guests.remove(name);
        return Response.ok((Object)("Removed " + name), (String)"text/plain").cacheControl(this.cc).build();
    }
}

