/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.scripts.impl.ScriptServiceImpl;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ScriptUpgradePlugin
extends UpgradeProductPlugin {
    private static final String EXO_ACTION = "exo:action";
    private static final String EXO_SCRIPT = "exo:script";
    private Log LOG = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private ScriptService scriptService_;

    public ScriptUpgradePlugin(ScriptService scriptService, InitParams initParams) {
        super(initParams);
        this.scriptService_ = scriptService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        this.replaceScripts();
        this.migrateScripts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceScripts() {
        String unchangedTemplates = PrivilegedSystemHelper.getProperty((String)"unchanged-scripts");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedTemplates)) {
            unchangedTemplates = "";
        }
        try {
            HashSet<String> unchangedTemplateSet = new HashSet<String>();
            Set allConfiguredScripts = this.scriptService_.getAllConfiguredScripts();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedTemplate : unchangedTemplates.split(",")) {
                unchangedTemplateSet.add(unchangedTemplate.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node ecmExplorer = this.scriptService_.getECMScriptHome(sessionProvider);
            QueryManager queryManager = ecmExplorer.getSession().getWorkspace().getQueryManager();
            NodeIterator iter = queryManager.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + ecmExplorer.getPath() + "/%'", "sql").execute().getNodes();
            while (iter.hasNext()) {
                Node scriptNode = iter.nextNode();
                if (unchangedTemplateSet.contains(scriptNode.getPath().substring(ecmExplorer.getPath().length() + 1)) || !allConfiguredScripts.contains(scriptNode.getName())) continue;
                removedNodes.add(scriptNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    ecmExplorer.save();
                }
                catch (Exception e) {
                    if (!this.LOG.isInfoEnabled()) continue;
                    this.LOG.error((Object)("Error in " + this.getName() + ": Can not remove old template: " + removedNode.getPath()));
                }
            }
            ((ScriptServiceImpl)this.scriptService_).start();
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"An unexpected error occurs when migrating scripts", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private void migrateScripts() {
        HashMap<String, String> scriptUpdateMap = new HashMap<String, String>();
        scriptUpdateMap.put("AddMetadataScript.groovy", "AddMetadata.groovy");
        scriptUpdateMap.put("AddTaxonomyActionScript.groovy", "AddToCategory.groovy");
        scriptUpdateMap.put("AddToFavoriteScript.groovy", "AddToFavorites.groovy");
        scriptUpdateMap.put("AutoVersioningScript.groovy", "AutoVersioning.groovy");
        scriptUpdateMap.put("EnableVersioningScript.groovy", "EnableVersioning.groovy");
        scriptUpdateMap.put("TrashFolderScript.groovy", "TrashFolder.groovy");
        ArrayList<String> oldUnrenamedScripts = new ArrayList<String>();
        oldUnrenamedScripts.add("GetMailScript.groovy");
        oldUnrenamedScripts.add("PopulateToHomePageMenu.groovy");
        oldUnrenamedScripts.add("ProcessRecordsScript.groovy");
        oldUnrenamedScripts.add("PublishingRequestScript.groovy");
        oldUnrenamedScripts.add("RSSScript.groovy");
        oldUnrenamedScripts.add("SendMailScript.groovy");
        oldUnrenamedScripts.add("TransformBinaryChildrenToTextScript.groovy");
        this.removeOldScripts(scriptUpdateMap);
        this.changeScriptNameInActionNode(scriptUpdateMap);
        this.addDcDescription();
        this.changeScriptNameInActionDataNode(scriptUpdateMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldScripts(Map<String, String> scriptUpdateMap) {
        SessionProvider sProvider = null;
        try {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"=====Start removing old renamed scripts =====");
            }
            ScriptService scriptService = (ScriptService)WCMCoreUtils.getService(ScriptService.class);
            sProvider = SessionProvider.createSystemProvider();
            Node scriptHome = scriptService.getECMScriptHome(sProvider);
            List actionScripts = scriptService.getECMActionScripts(sProvider);
            for (Node actionScript : actionScripts) {
                try {
                    if (!scriptUpdateMap.containsKey(actionScript.getName())) continue;
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info((Object)("Removing " + actionScript.getName()));
                    }
                    actionScript.remove();
                }
                catch (Exception e) {
                    if (!this.LOG.isErrorEnabled()) continue;
                    this.LOG.error((Object)("An unexpected error occurs when removing old renamed script: " + actionScript.getName()), (Throwable)e);
                }
            }
            scriptHome.save();
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"An unexpected error occurs when removing old renamed scripts: ", (Throwable)e);
            }
        }
        finally {
            if (sProvider != null) {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeScriptNameInActionNode(Map<String, String> scriptUpdateMap) {
        SessionProvider sProvider = null;
        try {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"=====Start changing script name to new ones in action using renamed scripts =====");
            }
            ActionServiceContainer actionServiceContainer = (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class);
            ExtendedNodeTypeManager nodetypeManager = WCMCoreUtils.getRepository().getNodeTypeManager();
            Collection actionTypes = actionServiceContainer.getCreatedActionTypes(WCMCoreUtils.getRepository().getConfiguration().getName());
            sProvider = SessionProvider.createSystemProvider();
            for (NodeType actionType : actionTypes) {
                try {
                    NodeTypeValue actionTypeValue = nodetypeManager.getNodeTypeValue(actionType.getName());
                    List propValues = actionTypeValue.getDeclaredPropertyDefinitionValues();
                    for (PropertyDefinitionValue propValue : propValues) {
                        String defaultValue;
                        String scriptName;
                        List defaultValues;
                        if (!EXO_SCRIPT.equals(propValue.getName()) || (defaultValues = propValue.getDefaultValueStrings()) == null || defaultValues.size() <= 0 || !scriptUpdateMap.containsKey(scriptName = (defaultValue = (String)defaultValues.get(0)).indexOf(47) > -1 ? defaultValue.substring(defaultValue.lastIndexOf(47) + 1) : defaultValue)) continue;
                        if (this.LOG.isInfoEnabled()) {
                            this.LOG.info((Object)("Changing for " + actionType.getName()));
                        }
                        defaultValues.set(0, defaultValue.replace(scriptName, scriptUpdateMap.get(scriptName)));
                        propValue.setDefaultValueStrings(defaultValues);
                        actionTypeValue.setDeclaredPropertyDefinitionValues(propValues);
                        nodetypeManager.registerNodeType(actionTypeValue, 4);
                    }
                }
                catch (Exception e) {
                    if (!this.LOG.isErrorEnabled()) continue;
                    this.LOG.error((Object)("An unexpected error occurs when change action action: " + actionType.getName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"An unexpected error occurs when changing actions: ", (Throwable)e);
            }
        }
        finally {
            if (sProvider != null) {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDcDescription() {
        SessionProvider sProvider = null;
        try {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"=====Start adding dc:description to old unrenamed scripts =====");
            }
            ScriptService scriptService = (ScriptService)WCMCoreUtils.getService(ScriptService.class);
            sProvider = SessionProvider.createSystemProvider();
            Node scriptHome = scriptService.getECMScriptHome(sProvider);
            List actionScripts = scriptService.getECMActionScripts(sProvider);
            for (Node actionScript : actionScripts) {
                String scriptName = actionScript.getName();
                try {
                    Node content;
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info((Object)("Adding dc:description for " + scriptName));
                    }
                    if ((content = actionScript.getNode("jcr:content")).hasProperty("dc:description")) continue;
                    if (content.canAddMixin("dc:elementSet")) {
                        content.addMixin("dc:elementSet");
                    }
                    String description = scriptName.indexOf(".") > -1 ? scriptName.substring(0, scriptName.indexOf(".")) : scriptName;
                    content.setProperty("dc:description", new String[]{description});
                }
                catch (Exception e) {
                    if (!this.LOG.isErrorEnabled()) continue;
                    this.LOG.error((Object)("An unexpected error occurs when removing old renamed script: " + scriptName), (Throwable)e);
                }
            }
            scriptHome.save();
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"An unexpected error occurs when adding dc:description to old unrenamed scripts: ", (Throwable)e);
            }
        }
        finally {
            if (sProvider != null) {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeScriptNameInActionDataNode(Map<String, String> scriptUpdateMap) {
        SessionProvider sProvider = null;
        try {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"=====Start changing script name to new ones in action data nodes using renamed scripts =====");
            }
            sProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = WCMCoreUtils.getRepository();
            String query = "SELECT * FROM exo:action";
            for (WorkspaceEntry wsEntry : repository.getConfiguration().getWorkspaceEntries()) {
                try {
                    String ws = wsEntry.getName();
                    Session session = sProvider.getSession(ws, repository);
                    NodeIterator iter = session.getWorkspace().getQueryManager().createQuery(query, "sql").execute().getNodes();
                    block8: while (iter.hasNext()) {
                        Node action = iter.nextNode();
                        if (!action.hasProperty(EXO_SCRIPT)) continue;
                        String oldScript = action.getProperty(EXO_SCRIPT).getString();
                        for (String script : scriptUpdateMap.keySet()) {
                            if (!oldScript.contains(script)) continue;
                            String newScript = oldScript.replace(script, scriptUpdateMap.get(script));
                            action.setProperty(EXO_SCRIPT, newScript);
                            action.save();
                            continue block8;
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.LOG.isErrorEnabled()) continue;
                    this.LOG.error((Object)("An unexpected error occurs when change action in workspace: " + wsEntry.getName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"An unexpected error occurs when changing actions: ", (Throwable)e);
            }
        }
        finally {
            if (sProvider != null) {
                sProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

