/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.nodetypes;

import java.util.List;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ActionableNodeTypeUpgradePlugin
extends UpgradeProductPlugin {
    private static final String actionableType = "exo:actionable";
    private static final String exoActionsProperty = "exo:actions";
    private Log log = ExoLogger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public ActionableNodeTypeUpgradePlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        block4: {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Migrating exo:actionable.............");
            }
            try {
                ExtendedNodeTypeManager nodeTypeManager = WCMCoreUtils.getRepository().getNodeTypeManager();
                NodeTypeValue nodeTypeValue = nodeTypeManager.getNodeTypeValue(actionableType);
                List propValues = nodeTypeValue.getDeclaredPropertyDefinitionValues();
                for (PropertyDefinitionValue propValue : propValues) {
                    if (!exoActionsProperty.equalsIgnoreCase(propValue.getName())) continue;
                    propValue.setMandatory(false);
                    break;
                }
                nodeTypeValue.setDeclaredPropertyDefinitionValues(propValues);
                nodeTypeManager.registerNodeType(nodeTypeValue, 4);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block4;
                this.log.error((Object)"An unexpected error occurs when migrating exo:actionable node type", (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

