/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.script.UIECMFilterForm;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIECMScripts
extends UIContainer {
    public static String SCRIPTLIST_NAME = "ECMScriptList";
    public static String SCRIPTFORM_NAME = "ECMScriptForm";
    public static String SCRIPT_PAGE = "PageIterator";

    public UIECMScripts() throws Exception {
        this.addChild(UIECMFilterForm.class, null, null);
        UIScriptList list = (UIScriptList)this.addChild(UIScriptList.class, null, SCRIPTLIST_NAME);
        list.getUIPageIterator().setId(SCRIPTLIST_NAME + SCRIPT_PAGE);
        UIPopupContainer uiPopupAction = (UIPopupContainer)this.addChild(UIPopupContainer.class, null, "ECMScriptPopupAction");
        ((UIPopupWindow)uiPopupAction.getChild(UIPopupWindow.class)).setId("ECMScriptPopupWindow");
    }

    private List<SelectItemOption<String>> getECMCategoryOptions() throws Exception {
        ArrayList<SelectItemOption<String>> ecmOptions = new ArrayList<SelectItemOption<String>>();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        Node ecmScriptHome = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMScriptHome(repository, SessionProviderFactory.createSystemProvider());
        NodeIterator categories = ecmScriptHome.getNodes();
        while (categories.hasNext()) {
            Node script = categories.nextNode();
            ecmOptions.add((SelectItemOption<String>)new SelectItemOption(script.getName(), (Object)script.getName()));
        }
        return ecmOptions;
    }

    public void refresh(int currentPage) throws Exception {
        UIECMFilterForm ecmFilterForm = (UIECMFilterForm)this.getChild(UIECMFilterForm.class);
        String categoryName = (String)ecmFilterForm.getUIFormSelectBox("selectScript").getValue();
        if (categoryName == null) {
            ecmFilterForm.setOptions(this.getECMCategoryOptions());
            categoryName = (String)ecmFilterForm.getUIFormSelectBox("selectScript").getValue();
        }
        UIScriptList uiScriptList = (UIScriptList)this.getChildById(SCRIPTLIST_NAME);
        uiScriptList.updateGrid(this.getECMScript(categoryName), currentPage);
    }

    public List<UIScriptList.ScriptData> getECMScript(String name) throws Exception {
        ArrayList<UIScriptList.ScriptData> scriptData = new ArrayList<UIScriptList.ScriptData>();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        List scripts = new ArrayList();
        if (name.equals("action")) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMActionScripts(repository, SessionProviderFactory.createSystemProvider());
        } else if (name.equals("widget")) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMWidgetScripts(repository, SessionProviderFactory.createSessionProvider());
        } else if (name.equals("interceptor")) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMInterceptorScripts(repository, SessionProviderFactory.createSystemProvider());
        }
        for (Node scriptNode : scripts) {
            String version = "";
            if (scriptNode.isNodeType("mix:versionable") && !scriptNode.isNodeType(Utils.NT_FROZEN)) {
                version = scriptNode.getBaseVersion().getName();
            }
            scriptData.add(new UIScriptList.ScriptData(scriptNode.getName(), scriptNode.getPath(), version));
        }
        return scriptData;
    }
}

