/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyWorkingArea;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyWorkingArea.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, confirm="UITaxonomyManager.msg.confirm-delete"), @EventConfig(listeners={CopyActionListener.class}), @EventConfig(listeners={PasteActionListener.class}), @EventConfig(listeners={CutActionListener.class}), @EventConfig(listeners={ViewPermissionActionListener.class})})
public class UITaxonomyWorkingArea
extends UIContainer {
    private UIPageIterator uiPageIterator_;
    private List<Node> taxonomyNodes_;
    private ClipboardCommand clipboard_ = new ClipboardCommand();
    private String selectedPath_;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UITaxonomyWorkingArea");

    public UITaxonomyWorkingArea() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UICategoriesSelect");
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getNodeList(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public List getListNodes() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void setNodeList(List<Node> nodes) {
        this.taxonomyNodes_ = nodes;
    }

    public List<Node> getNodeList() {
        return this.taxonomyNodes_;
    }

    private String getRepository() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        return uiManager.getRepository();
    }

    public boolean isRootNode() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        String selectedPath = uiManager.getSelectedPath();
        if (selectedPath == null) {
            selectedPath = uiManager.getRootNode().getPath();
        }
        return selectedPath.equals(uiManager.getRootNode().getPath());
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath_ = selectedPath;
    }

    public void update() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        if (this.selectedPath_ != null) {
            Node selectedTaxonomy = uiManager.getNodeByPath(this.selectedPath_);
            NodeIterator nodeIter = selectedTaxonomy.getNodes();
            ArrayList<Node> listNodes = new ArrayList<Node>();
            while (nodeIter.hasNext()) {
                Node node = nodeIter.nextNode();
                listNodes.add(node);
            }
            this.setNodeList(listNodes);
        }
        this.updateGrid();
    }

    static /* synthetic */ String access$000(UITaxonomyWorkingArea x0) throws Exception {
        return x0.getRepository();
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ ClipboardCommand access$202(UITaxonomyWorkingArea x0, ClipboardCommand x1) {
        x0.clipboard_ = x1;
        return x0.clipboard_;
    }

    static /* synthetic */ ClipboardCommand access$200(UITaxonomyWorkingArea x0) {
        return x0.clipboard_;
    }
}

