/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.namespace;

import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.NamespaceRegistry;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.namespace.UINamespaceList;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={AddNamespaceActionListener.class})})
public class UINamespaceList
extends UIGrid {
    private static String[] NAMESPACE_BEAN_FIELD = new String[]{"prefix", "uri"};

    public UINamespaceList() throws Exception {
        this.getUIPageIterator().setId("NamespaceListIterator");
        this.configure("prefix", NAMESPACE_BEAN_FIELD, null);
    }

    public String[] getActions() {
        return new String[]{"AddNamespace"};
    }

    public void updateGrid() throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        NamespaceRegistry namespaceRegistry = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getNamespaceRegistry();
        ArrayList<NamespaceBean> nspBeans = new ArrayList<NamespaceBean>();
        String[] prefixs = namespaceRegistry.getPrefixes();
        for (int i = 0; i < prefixs.length - 1; ++i) {
            NamespaceBean bean = new NamespaceBean(prefixs[i], namespaceRegistry.getURI(prefixs[i]));
            nspBeans.add(bean);
        }
        Collections.sort(nspBeans, new NameSpaceComparator());
        ObjectPageList objPageList = new ObjectPageList(nspBeans, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }
}

