/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeMainForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={ChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPathActionListener.class}), @EventConfig(listeners={NextViewPermissionActionListener.class})})
public class UITaxonomyTreeMainForm
extends UIForm {
    public static final String FIELD_NAME = "TaxoTreeName";
    public static final String FIELD_WORKSPACE = "TaxoTreeWorkspace";
    public static final String FIELD_HOMEPATH = "TaxoTreeHomePath";

    public UITaxonomyTreeMainForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormSelectBox uiSelectWorkspace = new UIFormSelectBox(FIELD_WORKSPACE, FIELD_WORKSPACE, null);
        this.addChild((UIComponent)uiSelectWorkspace);
        uiSelectWorkspace.setOnChange("Change");
        UIFormInputSetWithAction uiActionHomePath = new UIFormInputSetWithAction("TaxonomyTreeHomePath");
        uiActionHomePath.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_HOMEPATH, FIELD_HOMEPATH, null).setEditable(false));
        uiActionHomePath.setActionInfo(FIELD_HOMEPATH, new String[]{"AddPath"});
        this.addUIComponentInput((UIComponent)uiActionHomePath);
        this.setActions(new String[]{"Reset", "NextViewPermission"});
    }

    public void update(TaxonomyTreeData taxonomyTree) throws Exception {
        String repository = this.getRepository();
        String[] wsNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getWorkspaceNames();
        ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
        String systemWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getSystemWorkspaceName(repository);
        String dmsSystemWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getDmsSystemWorkspaceName(repository);
        for (String wsName : wsNames) {
            if (systemWorkspace.equals(wsName)) continue;
            workspace.add(new SelectItemOption(wsName, (Object)wsName));
        }
        if (taxonomyTree == null) {
            taxonomyTree = new TaxonomyTreeData();
        }
        UIFormSelectBox uiSelectBox = this.getUIFormSelectBox(FIELD_WORKSPACE).setOptions(workspace);
        if (taxonomyTree.getTaxoTreeWorkspace() == null) {
            taxonomyTree.setTaxoTreeWorkspace(dmsSystemWorkspace);
        }
        uiSelectBox.setValue(taxonomyTree.getTaxoTreeWorkspace());
        UIFormInputBase inputName = (UIFormInputBase)this.findComponentById(FIELD_NAME);
        UIFormInputBase inputHomePath = (UIFormInputBase)this.findComponentById(FIELD_HOMEPATH);
        String treeName = taxonomyTree.getTaxoTreeName();
        TaxonomyTreeData taxonomyTreeData = ((UITaxonomyTreeContainer)this.getParent()).getTaxonomyTreeData();
        if (taxonomyTreeData == null || !taxonomyTreeData.isEdit()) {
            inputName.setValue((Object)treeName);
        } else {
            inputName.setValue((Object)taxonomyTreeData.getTaxoTreeName());
        }
        inputHomePath.setValue((Object)taxonomyTree.getTaxoTreeHomePath());
        this.getUIStringInput(FIELD_NAME).setEditable(true);
        if (taxonomyTree != null && taxonomyTree.isEdit() || taxonomyTreeData != null && taxonomyTreeData.isEdit()) {
            this.getUIStringInput(FIELD_NAME).setEditable(false);
        }
    }

    private String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    int checkForm() throws Exception {
        UIFormStringInput input = (UIFormStringInput)this.getChildById(FIELD_WORKSPACE);
        if (input == null || input.getValue() == null || ((String)input.getValue()).length() == 0) {
            return 1;
        }
        UIFormSelectBox selectBox = (UIFormSelectBox)this.getChildById(FIELD_WORKSPACE);
        UIFormInputBase inputHomePath = (UIFormInputBase)this.findComponentById(FIELD_HOMEPATH);
        String homePath = "";
        if (inputHomePath != null && inputHomePath.getValue() != null) {
            homePath = inputHomePath.getValue().toString();
        }
        String dmsSysWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getDmsSystemWorkspaceName(this.getRepository());
        String workspace = (String)selectBox.getValue();
        if (homePath.length() == 0 && !dmsSysWorkspace.equals(workspace)) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ String access$000(UITaxonomyTreeMainForm x0) {
        return x0.getRepository();
    }
}

