/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.templates.UIDialogTab;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIDialogTab.msg.confirm-delete")})
public class UIDialogTab
extends UIContainer {
    private static final String[] BEAN_FIELD = new String[]{"name", "roles", "baseVersion"};
    private static final String[] ACTIONS = new String[]{"Edit", "Delete"};
    public static final String DIALOG_LIST_NAME = "DialogList";
    public static final String DIALOG_FORM_NAME = "DialogForm";
    private List<String> listDialog_ = new ArrayList();

    public UIDialogTab() throws Exception {
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, DIALOG_LIST_NAME);
        uiGrid.getUIPageIterator().setId("DialogListIterator");
        uiGrid.configure("name", BEAN_FIELD, ACTIONS);
        UITemplateContent uiForm = (UITemplateContent)this.addChild(UITemplateContent.class, null, DIALOG_FORM_NAME);
        uiForm.setTemplateType(TemplateService.DIALOGS);
        uiForm.update(null);
    }

    public List<String> getListDialog() {
        return this.listDialog_;
    }

    public void updateGrid(String nodeName, String repository) throws Exception {
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeIterator iter = tempService.getAllTemplatesOfNodeType(true, nodeName, repository, SessionProviderFactory.createSystemProvider());
        ArrayList<DialogData> data = new ArrayList<DialogData>();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            String version = "";
            StringBuilder rule = new StringBuilder();
            Value[] rules = node.getProperty("exo:roles").getValues();
            for (int i = 0; i < rules.length; ++i) {
                rule.append("[" + rules[i].getString() + "]");
            }
            if (node.isNodeType("mix:versionable") && !node.isNodeType(Utils.NT_FROZEN)) {
                version = node.getBaseVersion().getName();
            }
            this.listDialog_.add(node.getName());
            DialogData item = new DialogData(node.getName(), rule.toString(), version);
            data.add(item);
        }
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ObjectPageList objDPageList = new ObjectPageList(data, 4);
        uiGrid.getUIPageIterator().setPageList((PageList)objDPageList);
    }

    public void setTabRendered() {
        UIViewTemplate uiViewTemplate = (UIViewTemplate)this.getAncestorOfType(UIViewTemplate.class);
        uiViewTemplate.setRenderedChild(UIDialogTab.class);
    }
}

