/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.unlock;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.unlock.UILockNodeList;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/unlock/UILockNodeList.gtmpl", events={@EventConfig(listeners={UnLockActionListener.class})})
public class UILockNodeList
extends UIComponentDecorator {
    public static final String[] ACTIONS = new String[0];
    public static final String ST_EDIT = "EditUnLockForm";
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "LockNodeListIterator");
    private static final String LOCK_QUERY = "select * from nt:base where jcr:mixinTypes = 'mix:lockable' order by exo:dateCreated DESC";

    public UILockNodeList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void updateLockedNodesGrid(int currentPage) throws Exception {
        ObjectPageList pageList = new ObjectPageList(this.getAllLockedNodes(), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getLockedNodeList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public List<Node> getAllLockedNodes() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        RepositoryEntry repo = repositoryService.getConfig().getRepositoryConfiguration(repository);
        ManageableRepository manageRepository = repositoryService.getRepository(repository);
        ArrayList<Node> listLockedNodes = new ArrayList<Node>();
        QueryManager queryManager = null;
        Session session = null;
        String queryStatement = LOCK_QUERY;
        Query query = null;
        QueryResult queryResult = null;
        for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
            session = SessionProviderFactory.createSystemProvider().getSession(ws.getName(), manageRepository);
            queryManager = session.getWorkspace().getQueryManager();
            query = queryManager.createQuery(queryStatement, "sql");
            queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node itemNode = iter.nextNode();
                if (itemNode.isNodeType("exo:restoreLocation") || !itemNode.isLocked()) continue;
                listLockedNodes.add(itemNode);
            }
        }
        return listLockedNodes;
    }
}

