/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UICLVContainer
extends UIContainer {
    protected String messageKey;

    public abstract void init() throws Exception;

    public String getMessageKey() throws Exception {
        return this.messageKey;
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (!Boolean.parseBoolean(Utils.getCurrentMode()) || context.getFullRender()) {
            this.init();
        }
        super.processRender(context);
    }

    protected String getFormViewTemplatePath() {
        return Utils.getPortletPreference((String)"formViewTemplatePath");
    }

    public ResourceResolver getTemplateResourceResolver() throws Exception {
        String repository = WCMCoreUtils.getRepository(null).getConfiguration().getName();
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(repository).getSystemWorkspace();
        return new JCRResourceResolver(repository, workspace, "exo:templateFile");
    }

    public void onRefresh(Event<UICLVPresentation> event) throws Exception {
        UICLVPresentation clvPresentation = (UICLVPresentation)event.getSource();
        UICLVContainer uiListViewerBase = (UICLVContainer)clvPresentation.getParent();
        uiListViewerBase.getChildren().clear();
        uiListViewerBase.init();
    }
}

