/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.images.RESTImagesRendererService;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.CategoryBean;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPortlet;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={DeleteContentActionListener.class})}), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UICLVPresentation
extends UIContainer {
    private static final String defaultScvParam = "content-id";
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private DateFormat dateFormatter = null;
    private Map<String, String> tagStyles = null;

    public void init(String templatePath, ResourceResolver resourceResolver, PageList dataPageList) throws Exception {
        String paginatorTemplatePath = Utils.getPortletPreference((String)"paginatorTemplatePath");
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageList(dataPageList);
        Locale locale = Util.getPortalRequestContext().getLocale();
        this.dateFormatter = SimpleDateFormat.getDateTimeInstance(2, 2, locale);
    }

    public List<CategoryBean> getCategories() throws Exception {
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath();
        return this.getCategories(fullPath, "exo:taxonomy", 0);
    }

    public List<CategoryBean> getCategories(String primaryType) throws Exception {
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath();
        return this.getCategories(fullPath, primaryType, 0);
    }

    public List<CategoryBean> getCategories(String fullPath, String primaryType, int depth) throws Exception {
        WCMComposer wcmComposer = (WCMComposer)this.getApplicationComponent(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", Utils.getCurrentMode());
        String orderType = Utils.getPortletPreference((String)"orderType");
        String orderBy = Utils.getPortletPreference((String)"orderBy");
        filters.put("filter-order-by", orderBy);
        filters.put("filter-order-type", orderType);
        filters.put("filter-language", Util.getPortalRequestContext().getLocale().getLanguage());
        filters.put("filter-primary-type", primaryType);
        String clvBy = Utils.getPortletPreference((String)"showClvBy");
        String paramPath = Util.getPortalRequestContext().getRequestParameter(clvBy);
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByExpression((String)fullPath);
        List nodes = wcmComposer.getContents(nodeLocation.getRepository(), nodeLocation.getWorkspace(), nodeLocation.getPath(), filters, WCMCoreUtils.getUserSessionProvider());
        LinkedList<CategoryBean> categories = new LinkedList<CategoryBean>();
        for (Node node : nodes) {
            String title = this.getTitle(node);
            String url = this.getCategoryURL(node);
            String path = node.getPath();
            long total = node.hasProperty("exo:total") ? node.getProperty("exo:total").getValue().getLong() : 0L;
            boolean isSelected = paramPath != null && paramPath.endsWith(path);
            CategoryBean cat = new CategoryBean(node.getName(), node.getPath(), title, url, isSelected, depth, total);
            NodeLocation catLocation = NodeLocation.getNodeLocationByNode((Node)node);
            List childs = this.getCategories(catLocation.toString(), primaryType, depth + 1);
            if (childs != null && childs.size() > 0) {
                cat.setChilds(childs);
            }
            categories.add(cat);
        }
        return categories;
    }

    public String getTagHtmlStyle(long tagCount) throws Exception {
        for (Map.Entry entry : this.getTagStyles().entrySet()) {
            if (!this.checkTagRate(tagCount, (String)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return "";
    }

    private Map<String, String> getTagStyles() throws Exception {
        if (this.tagStyles == null) {
            NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
            String workspace = "dms-system";
            this.tagStyles = new HashMap();
            for (Node tag : folksonomyService.getAllTagStyle("repository", workspace)) {
                this.tagStyles.put(tag.getProperty("exo:styleRange").getValue().getString(), tag.getProperty("exo:htmlStyle").getValue().getString());
            }
        }
        return this.tagStyles;
    }

    private boolean checkTagRate(long numOfDocument, String range) throws Exception {
        String[] vals = StringUtils.split((String)range, (String)"..");
        int minValue = Integer.parseInt(vals[0]);
        int maxValue = vals[1].equals("*") ? Integer.MAX_VALUE : Integer.parseInt(vals[1]);
        return (long)minValue <= numOfDocument && numOfDocument < (long)maxValue;
    }

    public String getCategoryURL(Node node) throws Exception {
        String link = null;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String portalURI = portalRequestContext.getPortalURI();
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        String basePath = Utils.getPortletPreference((String)"basePath");
        String clvBy = Utils.getPortletPreference((String)"showClvBy");
        if (clvBy == null || clvBy.length() == 0) {
            clvBy = "folder-id";
        }
        link = baseURI + portalURI + basePath + "?" + clvBy + "=" + nodeLocation.getRepository() + ":" + nodeLocation.getWorkspace() + ":" + node.getPath();
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        link = friendlyService.getFriendlyUri(link);
        return link;
    }

    public boolean isShowField(String field) {
        String visible = Utils.getPortletPreference((String)field);
        return visible != null ? Boolean.parseBoolean(visible) : false;
    }

    public boolean showPaginator() throws Exception {
        String itemsPerPage = Utils.getPortletPreference((String)"itemsPerPage");
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public String getTitle(Node node) throws Exception {
        String title = null;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            if (content.hasProperty("dc:title")) {
                try {
                    title = content.getProperty("dc:title").getValues()[0].getString();
                }
                catch (Exception ex) {}
            }
        } else if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null) {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                title = originalNode.getName();
            } else {
                title = node.getName();
            }
        }
        return Text.unescapeIllegalJcrChars(title);
    }

    public String getSummary(Node node) throws Exception {
        Node content;
        String desc = null;
        if (node.hasProperty("exo:summary")) {
            desc = node.getProperty("exo:summary").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description")) {
            try {
                desc = content.getProperty("dc:description").getValues()[0].getString();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return desc;
    }

    public String getURL(Node node) throws Exception {
        String link = null;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String portalURI = portalRequestContext.getPortalURI();
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        String basePath = Utils.getPortletPreference((String)"basePath");
        String scvWith = Utils.getPortletPreference((String)"showScvWith");
        if (scvWith == null || scvWith.length() == 0) {
            scvWith = defaultScvParam;
        }
        link = baseURI + portalURI + basePath + "?" + scvWith + "=/" + nodeLocation.getRepository() + "/" + nodeLocation.getWorkspace() + node.getPath();
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPathParamValue();
        if (fullPath != null) {
            String clvBy = Utils.getPortletPreference((String)"showClvBy");
            link = link + "&" + clvBy + "=" + fullPath;
        }
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        link = friendlyService.getFriendlyUri(link);
        return link;
    }

    public String getWebdavURL(Node node) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String repository = nodeLocation.getRepository();
        String workspace = nodeLocation.getWorkspace();
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        String link = "#";
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + originalNode.getPath() + "?version=" + node.getParent().getName();
        } else {
            link = baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + node.getPath();
        }
        return friendlyService.getFriendlyUri(link);
    }

    public String getAuthor(Node node) throws Exception {
        if (node.hasProperty("exo:owner")) {
            String ownerId = node.getProperty("exo:owner").getValue().getString();
            return ownerId;
        }
        return null;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getModifiedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            Calendar calendar = node.getProperty("exo:dateModified").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getContentIcon(Node node) {
        try {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                return "Icon16x16 default16x16Icon " + org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)originalNode, (String)"16x16Icon");
            }
            return "Icon16x16 default16x16Icon " + org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)"16x16Icon");
        }
        catch (RepositoryException e) {
            Utils.createPopupMessage((org.exoplatform.webui.core.UIContainer)this, (String)"UIMessageBoard.msg.get-content-icon", null, (int)0);
            return null;
        }
    }

    public String getHeader() {
        String header = Utils.getPortletPreference((String)"header");
        UICLVContainer clvContainer = (UICLVContainer)this.getAncestorOfType(UICLVContainer.class);
        boolean isAutoDetect = Boolean.parseBoolean(Utils.getPortletPreference((String)"automaticDetection"));
        String contextualFolder = Utils.getPortletPreference((String)"contextualFolder");
        boolean isContextualEnable = "contextualEnable".equals(contextualFolder);
        String clvBy = Utils.getPortletPreference((String)"showClvBy");
        String paramPath = Util.getPortalRequestContext().getRequestParameter(clvBy);
        if (!(isAutoDetect && clvContainer.isModeByFolder() && paramPath != null && isContextualEnable)) {
            return header;
        }
        try {
            Node folderNode = NodeLocation.getNodeByExpression((String)((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath());
            if (folderNode.hasProperty("exo:title")) {
                String folderTitle = folderNode.getProperty("exo:title").getString();
                if (folderTitle != null && folderTitle.length() > 0) {
                    header = folderTitle;
                }
            } else {
                header = folderNode.getName();
            }
        }
        catch (RepositoryException repositoryException) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return header;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPaginator;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public void setDateTimeFormat(String format) {
        ((SimpleDateFormat)this.dateFormatter).applyPattern(format);
    }

    public String getEditLink(Node node, boolean isEditable, boolean isNew) {
        return Utils.getEditLink((Node)node, (boolean)isEditable, (boolean)isNew);
    }

    public boolean isShowEdit(Node node) {
        if (Utils.isShowQuickEdit()) {
            try {
                Node parent = node.getParent();
                ((ExtendedNode)node).checkPermission("set_property");
                ((ExtendedNode)parent).checkPermission("add_node");
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getIllustrativeImage(Node node) {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        RESTImagesRendererService imagesRendererService = (RESTImagesRendererService)this.getApplicationComponent(RESTImagesRendererService.class);
        Node illustrativeImage = null;
        String uri = null;
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = imagesRendererService.generateImageURI(illustrativeImage, null);
        }
        catch (PathNotFoundException ex) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uri;
    }

    public boolean isShowRssLink() {
        return this.isShowField("showRssLink") && (((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPathParamValue() != null || "AutoViewerMode".equals(Utils.getPortletPreference((String)"mode")));
    }

    public String getRssLink() {
        String portal = PortalContainer.getCurrentPortalContainerName();
        String rest = PortalContainer.getCurrentRestContextName();
        String server = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPathParamValue();
        if (fullPath == null || fullPath.length() == 0) {
            fullPath = Utils.getPortletPreference((String)"folderPath");
        }
        if (fullPath == null) {
            return "/" + portal + "/" + rest + "&siteName=" + Util.getUIPortal().getOwner() + "&orderBy=" + Utils.getPortletPreference((String)"orderBy") + "&orderType=" + Utils.getPortletPreference((String)"orderType") + "&detailPage=" + Utils.getPortletPreference((String)"basePath") + "&detailParam=" + Utils.getPortletPreference((String)"showScvWith");
        }
        String[] repoWsPath = fullPath.split(":");
        return "/" + portal + "/" + rest + "/feed/rss?repository=" + repoWsPath[0] + "&workspace=" + repoWsPath[1] + "&server=" + server + "&siteName=" + Util.getUIPortal().getOwner() + "&folderPath=" + repoWsPath[2] + "&orderBy=" + Utils.getPortletPreference((String)"orderBy") + "&orderType=" + Utils.getPortletPreference((String)"orderType") + "&detailPage=" + Utils.getPortletPreference((String)"basePath") + "&detailParam=" + Utils.getPortletPreference((String)"showScvWith");
    }

    public String addQuickEditDiv(String cssClass, Node viewNode) throws Exception {
        StringBuffer sb = new StringBuffer();
        String contentEditLink = this.getEditLink(viewNode, true, false);
        String contentDeleteLink = this.event("DeleteContent", NodeLocation.getExpressionByNode((Node)viewNode));
        String hoverClass = Utils.isShowQuickEdit() ? " ContainerHoverClassInner" : "";
        sb.append("<div class=\"" + cssClass + "\" onmouseover=\"this.className  = '" + cssClass + " " + hoverClass + "' \" onmouseout=\"this.className = '" + cssClass + "' \">");
        if (Utils.isShowQuickEdit()) {
            sb.append("\t<div class=\"EdittingContent\" style=\" z-index: 1\">");
            sb.append("\t\t<div class=\"EdittingToolBar \" >");
            sb.append("\t\t\t<div class=\"EdittingToolBarL\">");
            sb.append("\t\t\t\t<div class=\"EdittingToolBarC clearfix\">");
            if (Utils.isShowDelete((Node)viewNode)) {
                sb.append("\t\t\t\t\t<div style=\"float: right\">");
                sb.append("\t\t\t\t\t\t<a href=\"" + contentDeleteLink + "\" title=\"delete\"class=\"CloseContentIcon\" >");
                sb.append("\t\t\t\t\t\t  &nbsp;");
                sb.append("\t\t\t\t\t\t</a>");
                sb.append("\t\t\t\t\t</div>");
            }
            if (this.isShowEdit(viewNode)) {
                sb.append("\t\t\t\t\t<div style=\"float: right\">");
                sb.append("\t\t\t\t\t\t<a href=\"" + contentEditLink + "\" title=\"edit\" class=\"EditContentIcon\" >");
                sb.append("\t\t\t\t\t\t  &nbsp;");
                sb.append("\t\t\t\t\t\t</a>");
                sb.append("\t\t\t\t\t</div>");
            }
            sb.append("\t\t\t\t</div>");
            sb.append("\t\t\t</div>");
            sb.append("\t\t</div>");
            sb.append("\t</div>");
        }
        return sb.toString();
    }
}

