/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.util.Date;
import javax.jcr.Node;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderResponse;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISCVPreferences;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.w3c.dom.Element;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/SingleContentViewer/UISingleContentView.gtmpl")
public class UISingleContentViewerPortlet
extends UIPortletApplication {
    public static String REPOSITORY = "repository";
    public static String WORKSPACE = "workspace";
    public static String IDENTIFIER = "nodeIdentifier";
    public static String PARAMETER = "ParameterName";
    public static String SHOW_DATE = "ShowDate";
    public static String SHOW_TITLE = "ShowTitle";
    public static String SHOW_OPTIONBAR = "ShowOptionBar";
    public static String CONTEXTUAL_MODE = "ContextEnable";
    private PortletMode mode = PortletMode.VIEW;
    public static final String UIPreferencesPopupID = "UIPreferencesPopupWindows";
    private UISCVPreferences popPreferences;
    private UIPresentationContainer uiPresentation;
    PortletPreferences preferences;

    public UISingleContentViewerPortlet() throws Exception {
        this.addChild(UIPopupContainer.class, null, "UIPopupContainer-" + new Date().getTime());
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.preferences = portletRequestContext.getRequest().getPreferences();
        this.popPreferences = (UISCVPreferences)((UISCVPreferences)this.addChild(UISCVPreferences.class, null, null)).setRendered(false);
        this.uiPresentation = (UIPresentationContainer)this.addChild(UIPresentationContainer.class, null, null);
    }

    public void activateMode(PortletMode newMode) throws Exception {
        if (this.getChild(UIPresentationContainer.class) != null) {
            this.removeChild(UIPresentationContainer.class);
        }
        if (this.getChild(UISCVPreferences.class) != null) {
            this.removeChild(UISCVPreferences.class);
        }
        if (PortletMode.VIEW.equals((Object)newMode)) {
            ((UIPresentationContainer)this.addChild(UIPresentationContainer.class, null, null)).getNodeView();
        } else if (PortletMode.EDIT.equals((Object)newMode)) {
            ((UISCVPreferences)this.addChild(UISCVPreferences.class, null, null)).setInternalPreferencesMode(true);
        }
    }

    public boolean isViewMode() {
        System.out.println(Utils.getCurrentMode());
        return Utils.getCurrentMode().equals(PortletMode.VIEW);
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        Node node;
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        if (!this.mode.equals((Object)newMode)) {
            this.activateMode(newMode);
            this.mode = newMode;
        }
        if (this.uiPresentation != null && this.uiPresentation.isContextual() && this.uiPresentation.getNodeView() != null && (node = this.uiPresentation.getNodeView()) != null) {
            RenderResponse response = (RenderResponse)context.getResponse();
            Element title = response.createElement("title");
            title.setTextContent(this.uiPresentation.getTitle(node));
            response.addProperty("javax.portlet.markup.head.element", title);
        }
        super.processRender(app, context);
    }

    public void changeToViewMode() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletRequestContext.setApplicationMode(PortletMode.VIEW);
    }

    public Node getNodeByPreference() {
        try {
            String repository = this.preferences.getValue(REPOSITORY, null);
            String workspace = this.preferences.getValue(WORKSPACE, null);
            String nodeIdentifier = this.preferences.getValue(IDENTIFIER, null);
            WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
            return wcmService.getReferencedContent(Utils.getSessionProvider(), repository, workspace, nodeIdentifier);
        }
        catch (Exception e) {
            return null;
        }
    }
}

