/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pclv.config;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequestWrapper;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pclv.config.UIPCLVConfig;
import org.exoplatform.wcm.webui.validator.ZeroNumberValidator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/ParameterizedContentListViewer/config/UIPCLVConfig.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTargetPageActionListener.class}), @EventConfig(listeners={SaveActionListener.class})})
public class UIPCLVConfig
extends UIForm
implements UISelectable {
    public static final String HEADER = "Header";
    public static final String PORTLET_NAME = "Parameterized Content List Viewer";
    public static final String FORM_VIEW_TEMPLATE_CATEGORY = "content-list-viewer";
    public static final String PAGINATOR_TEMPLATE_CATEGORY = "paginators";
    public static final String ITEMS_PER_PAGE_INPUT = "ItemsPerPage";
    public static final String TARGET_PAGE_INPUT = "UIParameterizedTagetPageInput";
    public static final String TARGET_PATH_SELECTOR_POPUP_WINDOW = "UIParameterTargetPathPopupWindow";
    public static final String TARGET_PAGE_INPUT_SET_ACTION = "UIParameterizedTagetPageInputSetAction";
    public static final String PREFERENCE_TARGET_PATH = "targetPath";
    public static final String FORM_VIEW_TEMPLATES_SELECTOR = "FormViewTemplate";
    public static final String PAGINATOR_TEMPLATES_SELECTOR = "PaginatorTemplate";
    public static final String VIEWER_BUTTON_REFRESH = "ViewerButtonRefresh";
    public static final String VIEWER_THUMBNAILS_IMAGE = "ViewerThumbnailsView";
    public static final String VIEWER_TITLE = "ViewerTitle";
    public static final String VIEWER_DATE_CREATED = "ViewerDateCreated";
    public static final String VIEWER_SUMMARY = "ViewerSummary";
    public static final String VIEWER_HEADER = "ViewerHeader";
    public static final String AUTO_DETECT = "AutomaticDetection";
    public static final String SHOW_READMORE = "ShowReadMore";
    public static final String SHOW_RSS_LINK = "ShowRSSLink";
    public static final String SHOW_LINK = "ShowLink";
    public static final String ORDER_BY = "OrderBy";
    public static final String ORDER_BY_DATE_CREATED = "OrderByDateCreated";
    public static final String ORDER_TYPES = "OrderTypes";
    public static final String ORDER_DESC = "OrderDesc";
    public static final String ORDER_ASC = "OrderAsc";
    public static final String PREFERENCE_REPOSITORY = "repository";
    public static final String PREFERENCE_TREE_NAME = "treeName";
    public static final String TREE_NAME_FORM_SELECTBOX = "UICategoryNavigationTreeNameFormSelectBox";
    private String popupId;

    public UIPCLVConfig() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        ArrayList<SelectItemOption> orderTypeOptions = new ArrayList<SelectItemOption>();
        orderTypeOptions.add(new SelectItemOption(ORDER_DESC, (Object)"DESC"));
        orderTypeOptions.add(new SelectItemOption(ORDER_ASC, (Object)"ASC"));
        UIFormRadioBoxInput orderTypeRadioBoxInput = new UIFormRadioBoxInput(ORDER_TYPES, ORDER_TYPES, orderTypeOptions);
        String orderTypePref = portletPreferences.getValue("orderType", null);
        if (orderTypePref == null) {
            orderTypeRadioBoxInput.setValue((Object)"DESC");
        } else {
            orderTypeRadioBoxInput.setValue((Object)orderTypePref);
        }
        ArrayList<SelectItemOption> orderByOptions = new ArrayList<SelectItemOption>();
        orderByOptions.add(new SelectItemOption("OrderByTitle", (Object)"exo:title"));
        orderByOptions.add(new SelectItemOption(ORDER_BY_DATE_CREATED, (Object)"exo:dateCreated"));
        orderByOptions.add(new SelectItemOption("OrderByDateModified", (Object)"exo:dateModified"));
        orderByOptions.add(new SelectItemOption("OrderByDatePublished", (Object)"publication:liveDate"));
        orderByOptions.add(new SelectItemOption("OrderByDateStartEvent", (Object)"exo:startEvent"));
        UIFormSelectBox orderBySelectBox = new UIFormSelectBox(ORDER_BY, ORDER_BY, orderByOptions);
        String orderByPref = portletPreferences.getValue("orderBy", null);
        orderBySelectBox.setValue(orderByPref);
        UIFormCheckBoxInput autoDetect = new UIFormCheckBoxInput(AUTO_DETECT, AUTO_DETECT, null);
        autoDetect.setChecked(true);
        String autoDetected = portletPreferences.getValue("showAutoDetect", null);
        autoDetect.setChecked(Boolean.parseBoolean(autoDetected));
        UIFormStringInput headerInput = new UIFormStringInput(HEADER, HEADER, null);
        headerInput.setValue((Object)portletPreferences.getValue("header", null));
        List formViewerTemplateList = this.getTemplateList(PORTLET_NAME, FORM_VIEW_TEMPLATE_CATEGORY);
        List paginatorTemplateList = this.getTemplateList(PORTLET_NAME, PAGINATOR_TEMPLATE_CATEGORY);
        String preferenceRepository = portletPreferences.getValue(PREFERENCE_REPOSITORY, "");
        String preferenceTreeName = portletPreferences.getValue(PREFERENCE_TREE_NAME, "");
        List trees = this.getTaxonomyTrees(preferenceRepository);
        UIFormSelectBox treeNameFormSelectBox = new UIFormSelectBox(TREE_NAME_FORM_SELECTBOX, TREE_NAME_FORM_SELECTBOX, trees);
        treeNameFormSelectBox.setValue(preferenceTreeName);
        UIFormStringInput itemsPerPageStringInput = new UIFormStringInput(ITEMS_PER_PAGE_INPUT, ITEMS_PER_PAGE_INPUT, null);
        String itemsPerPageVal = portletPreferences.getValue("itemsPerPage", null);
        itemsPerPageStringInput.setValue((Object)itemsPerPageVal);
        itemsPerPageStringInput.addValidator(MandatoryValidator.class, new Object[0]);
        itemsPerPageStringInput.addValidator(ZeroNumberValidator.class, new Object[0]);
        itemsPerPageStringInput.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        itemsPerPageStringInput.setMaxLength(3);
        UIFormSelectBox formViewTemplateSelector = new UIFormSelectBox(FORM_VIEW_TEMPLATES_SELECTOR, FORM_VIEW_TEMPLATES_SELECTOR, formViewerTemplateList);
        String formViewTemplate = portletPreferences.getValue("formViewTemplatePath", null);
        formViewTemplateSelector.setValue(formViewTemplate);
        UIFormSelectBox paginatorTemplateSelector = new UIFormSelectBox(PAGINATOR_TEMPLATES_SELECTOR, PAGINATOR_TEMPLATES_SELECTOR, paginatorTemplateList);
        String paginatorTemplate = portletPreferences.getValue("paginatorTemplatePath", null);
        paginatorTemplateSelector.setValue(paginatorTemplate);
        UIFormCheckBoxInput viewerButtonRefreshCheckbox = new UIFormCheckBoxInput(VIEWER_BUTTON_REFRESH, VIEWER_BUTTON_REFRESH, null);
        viewerButtonRefreshCheckbox.setChecked(false);
        String refreshAble = portletPreferences.getValue("showRefreshButton", null);
        viewerButtonRefreshCheckbox.setChecked(Boolean.parseBoolean(refreshAble));
        UIFormCheckBoxInput thumbnailsViewCheckbox = new UIFormCheckBoxInput(VIEWER_THUMBNAILS_IMAGE, VIEWER_THUMBNAILS_IMAGE, null);
        thumbnailsViewCheckbox.setChecked(true);
        String imageShowAble = portletPreferences.getValue("showThumbnailsView", null);
        thumbnailsViewCheckbox.setChecked(Boolean.parseBoolean(imageShowAble));
        UIFormCheckBoxInput titleViewerCheckbox = new UIFormCheckBoxInput(VIEWER_TITLE, VIEWER_TITLE, null);
        titleViewerCheckbox.setChecked(true);
        String titleShowAble = portletPreferences.getValue("showTitle", null);
        titleViewerCheckbox.setChecked(Boolean.parseBoolean(titleShowAble));
        UIFormCheckBoxInput summaryViewerCheckbox = new UIFormCheckBoxInput(VIEWER_SUMMARY, VIEWER_SUMMARY, null);
        summaryViewerCheckbox.setChecked(true);
        String summaryShowAble = portletPreferences.getValue("showSummary", null);
        summaryViewerCheckbox.setChecked(Boolean.parseBoolean(summaryShowAble));
        UIFormCheckBoxInput dateCreatedViewerCheckbox = new UIFormCheckBoxInput(VIEWER_DATE_CREATED, VIEWER_DATE_CREATED, null);
        dateCreatedViewerCheckbox.setChecked(true);
        String dateShowAble = portletPreferences.getValue("showDateCreated", null);
        dateCreatedViewerCheckbox.setChecked(Boolean.parseBoolean(dateShowAble));
        UIFormCheckBoxInput viewerHeader = new UIFormCheckBoxInput(VIEWER_HEADER, VIEWER_HEADER, null);
        viewerHeader.setChecked(true);
        String viewHeader = portletPreferences.getValue("showHeader", null);
        viewerHeader.setChecked(Boolean.parseBoolean(viewHeader));
        String preferenceTargetPath = portletPreferences.getValue("targetPage", null);
        UIFormInputSetWithAction targetPathFormInputSet = new UIFormInputSetWithAction(TARGET_PAGE_INPUT_SET_ACTION);
        UIFormStringInput targetPathFormStringInput = new UIFormStringInput(TARGET_PAGE_INPUT, TARGET_PAGE_INPUT, preferenceTargetPath);
        targetPathFormStringInput.setValue((Object)preferenceTargetPath);
        targetPathFormStringInput.setEditable(false);
        targetPathFormInputSet.setActionInfo(TARGET_PAGE_INPUT, new String[]{"SelectTargetPage"});
        targetPathFormInputSet.addUIFormInput((UIFormInput)targetPathFormStringInput);
        UIFormCheckBoxInput readMoreLink = new UIFormCheckBoxInput(SHOW_READMORE, SHOW_READMORE, null);
        readMoreLink.setChecked(true);
        String showReadMore = portletPreferences.getValue("showReadMore", null);
        readMoreLink.setChecked(Boolean.parseBoolean(showReadMore));
        UIFormCheckBoxInput showRssLink = new UIFormCheckBoxInput(SHOW_RSS_LINK, SHOW_RSS_LINK, null);
        showRssLink.setChecked(true);
        String rssLink = portletPreferences.getValue("showRssLink", null);
        showRssLink.setChecked(Boolean.parseBoolean(rssLink));
        UIFormCheckBoxInput showLink = new UIFormCheckBoxInput(SHOW_LINK, SHOW_LINK, null);
        showLink.setChecked(true);
        String link = portletPreferences.getValue("showLink", null);
        showLink.setChecked(Boolean.parseBoolean(link));
        this.addChild((UIComponent)orderBySelectBox);
        this.addChild((UIComponent)orderTypeRadioBoxInput);
        this.addChild((UIComponent)headerInput);
        this.addChild((UIComponent)autoDetect);
        this.addChild((UIComponent)formViewTemplateSelector);
        this.addChild((UIComponent)paginatorTemplateSelector);
        this.addChild((UIComponent)treeNameFormSelectBox);
        this.addChild((UIComponent)itemsPerPageStringInput);
        this.addChild((UIComponent)viewerButtonRefreshCheckbox);
        this.addChild((UIComponent)thumbnailsViewCheckbox);
        this.addChild((UIComponent)titleViewerCheckbox);
        this.addChild((UIComponent)dateCreatedViewerCheckbox);
        this.addChild((UIComponent)summaryViewerCheckbox);
        this.addChild((UIComponent)viewerHeader);
        this.addChild((UIComponent)showLink);
        this.addChild((UIComponent)targetPathFormInputSet);
        this.addChild((UIComponent)readMoreLink);
        this.addChild((UIComponent)showRssLink);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private List<SelectItemOption<String>> getTaxonomyTrees(String repository) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        List taxonomyNodes = taxonomyService.getAllTaxonomyTrees(repository);
        ArrayList<SelectItemOption<String>> taxonomyTrees = new ArrayList<SelectItemOption<String>>();
        for (Node taxonomyNode : taxonomyNodes) {
            Node portalNode = livePortalManagerService.getLivePortalByChild(taxonomyNode);
            if (portalNode == null) continue;
            taxonomyTrees.add((SelectItemOption<String>)new SelectItemOption(taxonomyNode.getName(), (Object)taxonomyNode.getName()));
        }
        return taxonomyTrees;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        UIFormStringInput formStringInput = (UIFormStringInput)this.findComponentById(selectField);
        formStringInput.setValue((Object)value.toString());
        Utils.closePopupWindow((UIContainer)this, (String)"UICategoryNavigationTargetPathPopupWindow");
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateOptionList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String repository = manageableRepository.getConfiguration().getName();
        List templateNodeList = templateManagerService.getTemplatesByCategory(repository, portletName, category, Utils.getSessionProvider());
        for (Node templateNode : templateNodeList) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templateOptionList.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templateOptionList;
    }

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    private String getHeader() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)portletRequestContext.getRequest();
        String requestURI = requestWrapper.getRequestURI();
        String[] param = requestURI.split("/");
        String header = param[param.length - 1];
        return header;
    }
}

