/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UICLVContainer.gtmpl", events={@EventConfig(listeners={UICLVContainer.PreferencesActionListener.class})})
public class UICLVManualMode
extends UICLVContainer {
    public void init() throws Exception {
        PortletPreferences portletPreferences = Utils.getAllPortletPreferences();
        String sharedCache = portletPreferences.getValue("sharedCache", "true");
        sharedCache = "true".equals(sharedCache) ? "public" : "user";
        String[] listContent = portletPreferences.getValue("folderPath", null).split(";");
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (listContent != null && listContent.length != 0) {
            for (String itemPath : listContent) {
                NodeLocation nodeLocation = NodeLocation.getNodeLocationByExpression((String)itemPath);
                Node viewNode = Utils.getViewableNodeByComposer((String)nodeLocation.getRepository(), (String)Text.escapeIllegalJcrChars((String)nodeLocation.getWorkspace()), (String)Text.escapeIllegalJcrChars((String)nodeLocation.getPath()), null, (String)sharedCache);
                if (viewNode == null) continue;
                nodes.add(viewNode);
            }
        }
        if (nodes.size() == 0) {
            this.messageKey = "UICLVContainer.msg.non-contents";
        }
        this.getChildren().clear();
        ObjectPageList pageList = new ObjectPageList(nodes, itemsPerPage);
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        UICLVPresentation clvPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, null);
        clvPresentation.init(resourceResolver, (PageList)pageList);
    }

    public boolean isShowInfoBar() throws Exception {
        return UIPortlet.getCurrentUIPortlet().getShowInfoBar();
    }
}

