/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.comparator.ItemOptionNameComparator;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.wcm.webui.scv.config.UINameWebContentForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/SingleContentViewer/config/UINameWebContentForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AbortActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeTemplateTypeActionListener.class}, phase=Event.Phase.DECODE)})
public class UINameWebContentForm
extends UIForm {
    public static final String NAME_WEBCONTENT = "name".intern();
    public static final String SUMMARY_WEBCONTENT = "summary".intern();
    public static final String FIELD_SELECT = "selectTemplate".intern();
    private String pictureDescribe;

    public UINameWebContentForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME_WEBCONTENT, NAME_WEBCONTENT, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        UIFormSelectBox templateSelect = new UIFormSelectBox(FIELD_SELECT, FIELD_SELECT, this.getListFileType());
        templateSelect.setSelectedValues(new String[]{"exo:webContent"});
        templateSelect.setOnChange("ChangeTemplateType");
        templateSelect.setDefaultValue((Object)"exo:webContent");
        this.setPictureDescribe("exo_webContent");
        this.addUIFormInput((UIFormInput)templateSelect);
        this.setActions(new String[]{"Save", "Abort"});
    }

    private List<SelectItemOption<String>> getListFileType() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ExtendedNodeTypeManager nodeTypeManager = repositoryService.getCurrentRepository().getNodeTypeManager();
        List acceptableContentTypes = templateService.getDocumentTemplates();
        if (acceptableContentTypes.size() == 0) {
            return options;
        }
        String userName = Util.getPortalRequestContext().getRemoteUser();
        for (String contentType : acceptableContentTypes) {
            NodeType nodeType = nodeTypeManager.getNodeType(contentType);
            if (!nodeType.isNodeType("exo:webContent")) continue;
            String label = templateService.getTemplateLabel(contentType);
            try {
                String templatePath = templateService.getTemplatePathByUser(true, contentType, userName);
                if (templatePath == null || templatePath.length() <= 0) continue;
                options.add((SelectItemOption<String>)new SelectItemOption(label, (Object)contentType));
            }
            catch (Exception ex) {}
        }
        Collections.sort(options, new ItemOptionNameComparator());
        return options;
    }

    public String getPictureDescribe() {
        return this.pictureDescribe;
    }

    public void setPictureDescribe(String pictureDescribe) {
        this.pictureDescribe = pictureDescribe;
    }
}

