/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pclv;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pclv.UIPCLVContainer;
import org.exoplatform.wcm.webui.pclv.UIPCLVForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/ParameterizedContentListViewer/UIPCLVContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIPCLVContainer
extends UIContainer {
    private List<Node> listNode;
    private boolean isError;
    private Node categoryNode;
    private String taxonomyTreeName;

    public boolean isError() {
        return this.isError;
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }

    public List<Node> getListNode() {
        return this.listNode;
    }

    public void setListNode(List<Node> listNode) {
        this.listNode = listNode;
    }

    private String getHeader(String categoryPath) throws Exception {
        categoryPath = URLDecoder.decode(categoryPath, "UTF-8");
        String header = null;
        if (categoryPath != null && !"".equals(categoryPath)) {
            header = categoryPath.substring(categoryPath.lastIndexOf("/") + 1);
        }
        return header;
    }

    public void setCategoryNode(Node categoryNode) {
        this.categoryNode = categoryNode;
    }

    public Node getCategoryNode() {
        return this.categoryNode;
    }

    public void setTaxonomyTreeName(String taxonomyTreeName) {
        this.taxonomyTreeName = taxonomyTreeName;
    }

    public String getTaxonomyTreeName() {
        return this.taxonomyTreeName;
    }

    public void init() throws Exception {
        String[] categories;
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String preferenceRepository = portletPreferences.getValue("repository", "");
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        String categoryPath = null;
        try {
            categoryPath = URLDecoder.decode(StringUtils.substringAfter((String)Util.getPortalRequestContext().getNodePath(), (String)(Util.getUIPortal().getSelectedNode().getUri() + "/")), "UTF-8");
        }
        catch (Exception e) {
            Utils.createPopupMessage((org.exoplatform.webui.core.UIContainer)this, (String)"UIPCLVConfig.msg.decode", null, (int)0);
        }
        String gpath = Util.getPortalRequestContext().getRequestParameter("path");
        if (gpath != null && (categories = gpath.split("/")).length > 1) {
            preferenceTreeName = categories[1];
            categoryPath = gpath.substring(gpath.indexOf(preferenceTreeName) + preferenceTreeName.length() + 1);
        }
        Node treeNode = null;
        try {
            treeNode = taxonomyService.getTaxonomyTree(preferenceRepository, preferenceTreeName);
        }
        catch (RepositoryException ex) {
            // empty catch block
        }
        Node categoryNode = null;
        List nodes = new ArrayList();
        if (treeNode != null) {
            categoryNode = preferenceTreeName.equals(categoryPath) || "".equals(categoryPath) ? treeNode : treeNode.getNode(categoryPath);
            nodes = this.getListSymlinkNode(portletPreferences, categoryNode.getPath());
        }
        if (!categoryNode.isNodeType("exo:taxonomy")) {
            if (categoryPath != null && categoryPath.lastIndexOf("/") > -1) {
                categoryPath = categoryPath.substring(0, categoryPath.lastIndexOf("/"));
                categoryNode = treeNode.getNode(categoryPath);
            } else {
                categoryPath = "";
                categoryNode = treeNode;
            }
        }
        this.setTaxonomyTreeName(preferenceTreeName);
        this.setCategoryNode(categoryNode);
        this.setListNode(nodes);
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        PaginatedNodeIterator paginatedNodeIterator = new PaginatedNodeIterator(nodes, itemsPerPage);
        this.getChildren().clear();
        UIPCLVForm parameterizedContentListViewer = (UIPCLVForm)this.addChild(UIPCLVForm.class, null, null);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        parameterizedContentListViewer.init(templatePath, resourceResolver, (PageList)paginatedNodeIterator);
        parameterizedContentListViewer.setContentColumn(portletPreferences.getValue("header", null));
        parameterizedContentListViewer.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        String autoDetect = portletPreferences.getValue("showAutoDetect", null);
        String currentHeader = this.getHeader(categoryPath);
        if (treeNode != null && "true".equals(autoDetect) && currentHeader != null) {
            parameterizedContentListViewer.setHeader(currentHeader);
            if (categoryNode != null && categoryNode.hasProperty("exo:title")) {
                parameterizedContentListViewer.setHeader(categoryNode.getProperty("exo:title").getString());
            }
        } else {
            parameterizedContentListViewer.setHeader(portletPreferences.getValue("header", null));
        }
        parameterizedContentListViewer.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        parameterizedContentListViewer.setShowReadmore(Boolean.parseBoolean(portletPreferences.getValue("showReadMore", null)));
        parameterizedContentListViewer.setAutoDetection(autoDetect);
        parameterizedContentListViewer.setShowRSSLink(portletPreferences.getValue("showRssLink", null));
        String workspace = portletPreferences.getValue("workspace", null);
        String server = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
        server = server.substring(0, server.indexOf(47, 8));
        String portal = PortalContainer.getCurrentPortalContainerName();
        String rest = PortalContainer.getCurrentRestContextName();
        parameterizedContentListViewer.setRssLink("/" + portal + "/" + rest + "/rss/generate?repository=" + preferenceRepository + "&workspace=" + workspace + "&server=" + server + "&siteName=" + Util.getUIPortal().getOwner() + "&categoryPath=" + ("".equals(categoryPath) ? preferenceTreeName : preferenceTreeName + "/" + categoryPath));
    }

    public PortletPreferences getPortletPreference() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    public String getFormViewTemplatePath() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences references = portletRequestContext.getRequest().getPreferences();
        return references.getValue("formViewTemplatePath", null);
    }

    public ResourceResolver getTemplateResourceResolver() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences references = portletRequestContext.getRequest().getPreferences();
        String repository = references.getValue("repository", null);
        DMSConfiguration dmsConfiguration = (DMSConfiguration)Utils.getService(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(repository, workspace, "exo:templateFile");
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.init();
        super.processRender(context);
    }

    public void onRefresh(Event<UIPCLVForm> event) throws Exception {
        UIPCLVForm contentListPresentation = (UIPCLVForm)event.getSource();
        UIPCLVContainer uiParameterizedContentListontainer = (UIPCLVContainer)contentListPresentation.getParent();
        uiParameterizedContentListontainer.getChildren().clear();
        uiParameterizedContentListontainer.init();
    }

    private List<Node> getListSymlinkNode(PortletPreferences portletPreferences, String categoryPath) throws Exception {
        String repository = portletPreferences.getValue("repository", "");
        String workspace = portletPreferences.getValue("workspace", "");
        String orderType = portletPreferences.getValue("orderType", "");
        String orderBy = portletPreferences.getValue("orderBy", "");
        if ("".equals(orderType)) {
            orderType = "DESC";
        }
        if ("".equals(orderBy)) {
            orderBy = "exo:dateCreated";
        }
        WCMComposer wcmComposer = (WCMComposer)this.getApplicationComponent(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", Utils.getCurrentMode());
        filters.put("filter-order-by", orderBy);
        filters.put("filter-order-type", orderType);
        filters.put("filter-language", Util.getPortalRequestContext().getLocale().getLanguage());
        List nodes = wcmComposer.getContents(repository, workspace, categoryPath, filters, Utils.getSessionProvider());
        return nodes;
    }
}

