/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/SingleContentViewer/UIPresentationContainer.gtmpl", events={@EventConfig(listeners={PreferencesActionListener.class}), @EventConfig(listeners={FastPublishActionListener.class})})
public class UIPresentationContainer
extends UIContainer {
    public static final String PARAMETER_REGX = "(.*)/(.*)";
    private boolean isPrint = false;
    private PortletPreferences portletPreferences;
    private String contentParameter = null;

    public UIPresentationContainer() throws Exception {
        this.addChild(UIPresentation.class, null, null);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.portletPreferences = portletRequestContext.getRequest().getPreferences();
    }

    public boolean isShowInfoBar() throws Exception {
        return UIPortlet.getCurrentUIPortlet().getShowInfoBar();
    }

    public String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception e) {
                title = null;
            }
        }
        if (title == null) {
            title = node.getName();
        }
        return Text.unescapeIllegalJcrChars((String)title);
    }

    public boolean isPrinting() {
        return this.isPrint;
    }

    public boolean isShowTitle() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_TITLE, "false"));
    }

    public boolean isShowDate() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_DATE, "false"));
    }

    public boolean isShowOptionBar() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_OPTIONBAR, "false"));
    }

    public boolean isContextual() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.CONTEXTUAL_MODE, "false"));
    }

    public String getCurrentState() throws Exception {
        UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
        Node node = presentation.getOriginalNode();
        if (node != null && node.hasProperty("publication:currentState")) {
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            String state = node.getProperty("publication:currentState").getValue().getString();
            try {
                state = portletRequestContext.getApplicationResourceBundle().getString("PublicationStates." + state);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            return state;
        }
        return "";
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return new SimpleDateFormat("dd.MM.yyyy '|' hh'h'mm").format(calendar.getTime());
        }
        return null;
    }

    public Node getNodeView() {
        UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
        try {
            String sharedCache;
            String nodeIdentifier;
            String workspace;
            Node viewNode = this.getParameterizedNode();
            if (viewNode != null) {
                if (viewNode.isNodeType("nt:frozenNode")) {
                    try {
                        String nodeUUID = viewNode.getProperty("jcr:frozenUuid").getString();
                        presentation.setOriginalNode(viewNode.getSession().getNodeByUUID(nodeUUID));
                        presentation.setNode(viewNode);
                    }
                    catch (Exception ex) {
                        return viewNode;
                    }
                }
                return viewNode;
            }
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            this.portletPreferences = portletRequestContext.getRequest().getPreferences();
            String repository = this.portletPreferences.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
            viewNode = Utils.getRealNode((String)repository, (String)(workspace = this.portletPreferences.getValue(UISingleContentViewerPortlet.WORKSPACE, null)), (String)(nodeIdentifier = this.portletPreferences.getValue(UISingleContentViewerPortlet.IDENTIFIER, null)), (boolean)false, (String)(sharedCache = "true".equals(sharedCache = this.portletPreferences.getValue("sharedCache", "true")) ? "public" : "user"));
            if (viewNode != null) {
                boolean isDocumentType = false;
                if (viewNode.isNodeType("nt:frozenNode")) {
                    isDocumentType = true;
                }
                TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
                List documentTypes = templateService.getDocumentTemplates();
                for (String documentType : documentTypes) {
                    if (!viewNode.isNodeType(documentType)) continue;
                    isDocumentType = true;
                    break;
                }
                if (!isDocumentType) {
                    return null;
                }
                if (viewNode != null && viewNode.isNodeType("nt:frozenNode")) {
                    String nodeUUID = viewNode.getProperty("jcr:frozenUuid").getString();
                    presentation.setOriginalNode(viewNode.getSession().getNodeByUUID(nodeUUID));
                    presentation.setNode(viewNode);
                } else {
                    presentation.setOriginalNode(viewNode);
                    presentation.setNode(viewNode);
                }
            }
            return viewNode;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Node getParameterizedNode() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String sharedCache = preferences.getValue("sharedCache", "false");
        sharedCache = "true".equals(sharedCache) ? "public" : "user";
        PortalRequestContext preq = Util.getPortalRequestContext();
        if (!preq.useAjax()) {
            this.contentParameter = this.getRequestParameters();
        }
        if (this.contentParameter == null) {
            return null;
        }
        UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
        Node nodeView = Utils.getViewableNodeByComposer(null, null, (String)this.contentParameter, null, (String)sharedCache);
        if (nodeView != null) {
            boolean isDocumentType = false;
            if (nodeView.isNodeType("nt:frozenNode")) {
                isDocumentType = true;
            }
            if (!isDocumentType) {
                TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
                List documentTypes = templateService.getDocumentTemplates();
                for (String documentType : documentTypes) {
                    if (!nodeView.isNodeType(documentType)) continue;
                    isDocumentType = true;
                    break;
                }
            }
            if (!isDocumentType) {
                return null;
            }
            if (nodeView != null && nodeView.isNodeType("nt:frozenNode")) {
                String nodeUUID = nodeView.getProperty("jcr:frozenUuid").getString();
                presentation.setOriginalNode(nodeView.getSession().getNodeByUUID(nodeUUID));
                presentation.setNode(nodeView);
            } else {
                if (nodeView == null) {
                    return null;
                }
                presentation.setOriginalNode(nodeView);
                presentation.setNode(nodeView);
            }
            this.isPrint = Boolean.parseBoolean(Util.getPortalRequestContext().getRequestParameter("isPrint"));
        }
        return nodeView;
    }

    private String getRequestParameters() throws Exception {
        String parameters = null;
        if (!Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.CONTEXTUAL_MODE, "false"))) {
            return null;
        }
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)Util.getPortalRequestContext().getNodePath(), (String)(Util.getUIPortal().getSelectedUserNode().getURI() + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        String parameterName = this.portletPreferences.getValue(UISingleContentViewerPortlet.PARAMETER, "");
        if (!parameters.matches(PARAMETER_REGX)) {
            String path = Util.getPortalRequestContext().getRequestParameter(parameterName);
            if (path == null) {
                return null;
            }
            parameters = Text.unescape((String)Util.getPortalRequestContext().getRequestParameter(parameterName));
            return parameters.substring(1);
        }
        return Text.unescape((String)parameters);
    }

    @Deprecated
    public String getPrintUrl() throws RepositoryException {
        return this.getPrintUrl(null);
    }

    public String getPrintUrl(Node node) throws RepositoryException {
        Node tempNode = node;
        if (tempNode == null) {
            tempNode = this.getNodeView();
        }
        String strPath = tempNode.getPath();
        String repository = ((ManageableRepository)tempNode.getSession().getRepository()).getConfiguration().getName();
        String workspace = tempNode.getSession().getWorkspace().getName();
        String printPageUrl = this.portletPreferences.getValue(UISingleContentViewerPortlet.PRINT_PAGE, "");
        String printParameterName = this.portletPreferences.getValue(UISingleContentViewerPortlet.PRINT_PARAMETER, "");
        String paramName = "/" + repository + "/" + workspace + strPath;
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), printPageUrl);
        nodeURL.setResource(resource);
        nodeURL.setQueryParameterValue(printParameterName, paramName);
        nodeURL.setQueryParameterValue("isPrint", "true");
        nodeURL.setQueryParameterValue("noadminbar", "true");
        return nodeURL.toString();
    }

    @Deprecated
    public String getQuickEditLink() {
        return this.getQuickEditLink(null);
    }

    public String getQuickEditLink(Node node) {
        Node tempNode = node;
        if (tempNode == null) {
            tempNode = this.getNodeView();
        }
        return Utils.getEditLink((Node)tempNode, (boolean)true, (boolean)false);
    }

    public Node getOriginalNode() {
        UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
        if (presentation == null) {
            return null;
        }
        try {
            return presentation.getOriginalNode();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isViewMode() {
        return Utils.getCurrentMode().equals("Live");
    }

    public String getInlineEditingMsg() {
        StringBuffer sb = new StringBuffer();
        sb.append("new Array(");
        ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
        sb.append("'").append(Text.escapeIllegalJcrChars((String)resourceBundle.getString("UIPresentationContainer.msg.internal-server-error"))).append("', '").append(Text.escapeIllegalJcrChars((String)resourceBundle.getString("UIPresentationContainer.msg.empty-title-error"))).append("')");
        return sb.toString();
    }

    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName, (String)defaultValue, (String)inputType, (String)idGenerator, (String)cssClass, (boolean)isGenericProperty, (String[])arguments);
    }

    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName);
    }
}

