/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.Node;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVConfig;
import org.exoplatform.wcm.webui.clv.UICLVFolderMode;
import org.exoplatform.wcm.webui.clv.UICLVManualMode;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/ContentListViewer/UICLVPortlet.gtmpl")
public class UICLVPortlet
extends UIPortletApplication {
    public static final String PREFERENCE_DISPLAY_MODE = "mode";
    public static final String PREFERENCE_ITEM_PATH = "folderPath";
    public static final String PREFERENCE_ITEM_DRIVE = "nodeDrive";
    public static final String PREFERENCE_ORDER_BY = "orderBy";
    public static final String ORDER_BY_TITLE = "OrderByTitle";
    public static final String ORDER_BY_DATE_CREATED = "OrderByDateCreated";
    public static final String ORDER_BY_DATE_MODIFIED = "OrderByDateModified";
    public static final String ORDER_BY_DATE_PUBLISHED = "OrderByDatePublished";
    public static final String ORDER_BY_DATE_START_EVENT = "OrderByDateStartEvent";
    public static final String ORDER_BY_INDEX = "OrderByIndex";
    public static final String PREFERENCE_ORDER_TYPE = "orderType";
    public static final String ORDER_TYPE_DESCENDENT = "OrderDesc";
    public static final String ORDER_TYPE_ASCENDENT = "OrderAsc";
    public static final String PREFERENCE_HEADER = "header";
    public static final String PREFERENCE_AUTOMATIC_DETECTION = "automaticDetection";
    public static final String PREFERENCE_DISPLAY_TEMPLATE = "formViewTemplatePath";
    public static final String PREFERENCE_PAGINATOR_TEMPLATE = "paginatorTemplatePath";
    public static final String PREFERENCE_ITEMS_PER_PAGE = "itemsPerPage";
    public static final String PREFERENCE_SHOW_TITLE = "showTitle";
    public static final String PREFERENCE_SHOW_HEADER = "showHeader";
    public static final String PREFERENCE_SHOW_REFRESH_BUTTON = "showRefreshButton";
    public static final String PREFERENCE_SHOW_ILLUSTRATION = "showThumbnailsView";
    public static final String PREFERENCE_SHOW_DATE_CREATED = "showDateCreated";
    public static final String PREFERENCE_SHOW_READMORE = "showReadmore";
    public static final String PREFERENCE_SHOW_SUMMARY = "showSummary";
    public static final String PREFERENCE_SHOW_LINK = "showLink";
    public static final String PREFERENCE_SHOW_RSSLINK = "showRssLink";
    public static final String PREFERENCE_CONTEXTUAL_FOLDER = "contextualFolder";
    public static final String PREFERENCE_CONTEXTUAL_FOLDER_ENABLE = "contextualEnable";
    public static final String PREFERENCE_CONTEXTUAL_FOLDER_DISABLE = "contextualDisable";
    public static final String PREFERENCE_TARGET_PAGE = "basePath";
    public static final String PREFERENCE_SHOW_SCV_WITH = "showScvWith";
    public static final String PREFERENCE_SHOW_CLV_BY = "showClvBy";
    public static final String PREFERENCE_CACHE_ENABLED = "sharedCache";
    public static final String PREFERENCE_CONTENTS_BY_QUERY = "query";
    public static final String PREFERENCE_WORKSPACE = "workspace";
    public static final String DISPLAY_MODE_MANUAL = "ManualViewerMode";
    public static final String DISPLAY_MODE_AUTOMATIC = "AutoViewerMode";
    public static final String DEFAULT_SHOW_CLV_BY = "folder-id";
    public static final String DEFAULT_SHOW_SCV_WITH = "content-id";
    public static final String PREFERENCE_APPLICATION_TYPE = "application";
    public static final String APPLICATION_CLV_BY_QUERY = "ContentsByQuery";
    public static final String PREFERENCE_SHARED_CACHE = "sharedCache";
    public static final String QUERY_USER_PARAMETER = "user";
    public static final String QUERY_LANGUAGE_PARAMETER = "lang";
    private PortletMode cpMode;
    private UICLVFolderMode folderMode;
    private UICLVManualMode manualMode;
    private UICLVConfig clvConfig;
    private String currentFolderPath;
    private String currentDisplayMode;
    private String currentApplicationMode;

    public UICLVPortlet() throws Exception {
        this.addChild(UIPopupContainer.class, null, "UIPopupContainer-" + new Date().getTime());
        this.currentFolderPath = this.getFolderPath();
    }

    public void setCurrentFolderPath(String value) {
        this.currentFolderPath = value;
    }

    public String getFolderPath() {
        PortalRequestContext preq = Util.getPortalRequestContext();
        this.currentFolderPath = "";
        if (!preq.useAjax()) {
            this.currentFolderPath = this.getFolderPathParamValue();
        }
        PortletPreferences preferences = Utils.getAllPortletPreferences();
        this.currentDisplayMode = preferences.getValue(PREFERENCE_DISPLAY_MODE, null);
        this.currentApplicationMode = preferences.getValue(PREFERENCE_APPLICATION_TYPE, null);
        if (DISPLAY_MODE_AUTOMATIC.equals(this.currentDisplayMode) && (this.currentFolderPath == null || this.currentFolderPath.length() == 0)) {
            this.currentFolderPath = Utils.getPortletPreference((String)PREFERENCE_ITEM_PATH);
        }
        return this.currentFolderPath;
    }

    public String getFolderPathParamValue() {
        PortletPreferences preferences = Utils.getAllPortletPreferences();
        String contextualMode = preferences.getValue(PREFERENCE_CONTEXTUAL_FOLDER, null);
        Node folderNode = null;
        String folderPath = null;
        if (PREFERENCE_CONTEXTUAL_FOLDER_ENABLE.equals(contextualMode)) {
            String folderParamName = preferences.getValue(PREFERENCE_SHOW_CLV_BY, null);
            if (folderParamName == null || folderParamName.length() == 0) {
                folderParamName = DEFAULT_SHOW_CLV_BY;
            }
            folderPath = Util.getPortalRequestContext().getRequestParameter(folderParamName);
            try {
                NodeLocation folderLocation = NodeLocation.getNodeLocationByExpression((String)folderPath);
                folderNode = NodeLocation.getNodeByLocation((NodeLocation)folderLocation);
                if (folderNode == null) {
                    return null;
                }
            }
            catch (Exception e) {
                folderNode = null;
                folderPath = null;
            }
        }
        return folderPath;
    }

    public HashMap<String, String> getQueryParammeter(HashSet<String> params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        PortalRequestContext context = Util.getPortalRequestContext();
        for (String param : params) {
            String value = context.getRequestParameter(param);
            if (value != null) {
                paramMap.put(param, value);
                continue;
            }
            paramMap.put(param, "");
        }
        paramMap.put(QUERY_USER_PARAMETER, context.getRemoteUser());
        paramMap.put(QUERY_LANGUAGE_PARAMETER, context.getLocale().getLanguage());
        return paramMap;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletPreferences preferences = pContext.getRequest().getPreferences();
        Boolean sharedCache = "true".equals(preferences.getValue("sharedCache", "true"));
        if (context.getRemoteUser() == null || Utils.isLiveMode() && sharedCache.booleanValue() && !Utils.isPortalEditMode() && PortletMode.VIEW.equals((Object)pContext.getApplicationMode())) {
            WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
            pContext.getResponse().setProperty("portlet.expiration-cache", "" + wcmService.getPortletExpirationCache());
            if (log.isTraceEnabled()) {
                log.trace((Object)("CLV rendering : cache set to " + wcmService.getPortletExpirationCache()));
            }
        }
        String nDisplayMode = preferences.getValue(PREFERENCE_DISPLAY_MODE, null);
        PortletMode npMode = pContext.getApplicationMode();
        if (!nDisplayMode.equals(this.currentDisplayMode)) {
            this.activateMode(npMode, nDisplayMode);
        } else if (!npMode.equals((Object)this.cpMode)) {
            this.activateMode(npMode, nDisplayMode);
        }
        this.setId(UICLVPortlet.class.getSimpleName() + "_" + pContext.getWindowId());
        super.processRender(app, context);
    }

    private void activateMode(PortletMode npMode, String nDisplayMode) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        if (npMode.equals((Object)this.cpMode)) {
            this.removeChildren();
            if (Utils.isPortalEditMode()) {
                this.clvConfig = (UICLVConfig)this.addChild(UICLVConfig.class, null, null);
                this.clvConfig.setModeInternal(false);
            } else if (nDisplayMode.equals(DISPLAY_MODE_AUTOMATIC)) {
                this.folderMode = (UICLVFolderMode)this.addChild(UICLVFolderMode.class, null, UICLVFolderMode.class.getSimpleName() + "_" + pContext.getWindowId());
                this.folderMode.init();
                this.folderMode.setRendered(true);
            } else {
                this.manualMode = (UICLVManualMode)this.addChild(UICLVManualMode.class, null, UICLVManualMode.class.getSimpleName() + "_" + pContext.getWindowId());
                this.manualMode.init();
                this.manualMode.setRendered(true);
            }
        } else if (npMode.equals((Object)PortletMode.VIEW)) {
            this.removeChildren();
            if (nDisplayMode.equals(DISPLAY_MODE_AUTOMATIC)) {
                this.folderMode = (UICLVFolderMode)this.addChild(UICLVFolderMode.class, null, UICLVFolderMode.class.getSimpleName() + "_" + pContext.getWindowId());
                this.folderMode.init();
                this.folderMode.setRendered(true);
            } else {
                this.manualMode = (UICLVManualMode)this.addChild(UICLVManualMode.class, null, UICLVManualMode.class.getSimpleName() + "_" + pContext.getWindowId());
                this.manualMode.init();
                this.manualMode.setRendered(true);
            }
        } else {
            this.removeChildren();
            this.clvConfig = (UICLVConfig)this.addChild(UICLVConfig.class, null, null);
            this.clvConfig.setModeInternal(true);
        }
        this.cpMode = npMode;
        this.currentDisplayMode = nDisplayMode;
    }

    private void removeChildren() {
        this.clvConfig = (UICLVConfig)this.getChild(UICLVConfig.class);
        if (this.clvConfig != null) {
            this.removeChild(UICLVConfig.class);
        }
        this.folderMode = (UICLVFolderMode)this.getChild(UICLVFolderMode.class);
        if (this.folderMode != null) {
            this.removeChild(UICLVFolderMode.class);
        }
        this.manualMode = (UICLVManualMode)this.getChild(UICLVManualMode.class);
        if (this.manualMode != null) {
            this.removeChild(UICLVManualMode.class);
        }
    }

    public void changeToViewMode() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletRequestContext.setApplicationMode(PortletMode.VIEW);
        this.updatePortlet();
    }

    public void updatePortlet() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletMode npMode = portletRequestContext.getApplicationMode();
        PortletPreferences preferences = Utils.getAllPortletPreferences();
        String nDisplayMode = preferences.getValue(PREFERENCE_DISPLAY_MODE, null);
        this.activateMode(npMode, nDisplayMode);
    }

    public String getQueryStatement(String sqlQuery) {
        HashSet params = Utils.getQueryParams((String)sqlQuery);
        HashMap queryParam = this.getQueryParammeter(params);
        return Utils.buildQuery((String)sqlQuery, (HashMap)queryParam);
    }

    public boolean isQueryApplication() {
        return APPLICATION_CLV_BY_QUERY.equals(this.currentApplicationMode);
    }
}

