/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVPortlet;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UICLVContainer
extends UIContainer {
    protected String messageKey;

    public abstract void init() throws Exception;

    public String getMessageKey() throws Exception {
        return this.messageKey;
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (!Boolean.parseBoolean(Utils.getCurrentMode()) || context.getFullRender()) {
            this.init();
        }
        super.processRender(context);
    }

    public String getEditLink(boolean isEditable, boolean isNew) {
        String folderPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath();
        if (folderPath == null) {
            folderPath = "";
        }
        return Utils.getEditLink((String)this.correctPath(folderPath), (boolean)isEditable, (boolean)isNew);
    }

    public Node getFolderNode() {
        return NodeLocation.getNodeByExpression((String)Utils.getPortletPreference((String)"folderPath"));
    }

    private String correctPath(String oldPath) {
        if (oldPath == null || oldPath != null && oldPath.length() == 0) {
            return "";
        }
        int slashIndex = oldPath.indexOf("/");
        String path = oldPath.substring(slashIndex + 1);
        String[] repoWorkspace = oldPath.substring(0, slashIndex).split(":");
        String strWorkspace = repoWorkspace[1];
        return strWorkspace + '/' + path;
    }

    public ResourceResolver getTemplateResourceResolver() throws Exception {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    public void onRefresh(Event<UICLVPresentation> event) throws Exception {
        UICLVPresentation clvPresentation = (UICLVPresentation)event.getSource();
        UICLVContainer uiListViewerBase = (UICLVContainer)clvPresentation.getParent();
        uiListViewerBase.getChildren().clear();
        uiListViewerBase.init();
    }

    public boolean isModeByFolder() {
        PortletPreferences portletPreferences = Utils.getAllPortletPreferences();
        String currentApplicationMode = portletPreferences.getValue("application", null);
        if (currentApplicationMode.equals("ContentsByQuery")) {
            return false;
        }
        return "AutoViewerMode".equals(Utils.getPortletPreference((String)"mode"));
    }

    public boolean isShowManageContent() {
        return Utils.isShowQuickEdit() && this.isModeByFolder();
    }

    public boolean isShowAddContent() {
        if (this.isShowManageContent()) {
            PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
            String itemPath = portletPreferences.getValue("folderPath", null);
            try {
                Node content = NodeLocation.getNodeByExpression((String)itemPath);
                ((ExtendedNode)content).checkPermission("add_node");
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isShowPreferences() {
        try {
            return Utils.isShowQuickEdit() && Utils.hasEditPermissionOnPage();
        }
        catch (Exception e) {
            return false;
        }
    }
}

