/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.io.Serializable;
import org.jboss.kernel.api.dependency.NumberMatcher;

public class IntervalMatcher
extends NumberMatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Number floor;
    private Number ceiling;
    private boolean floorIsGreaterThan;
    private boolean ceilingIsLessThan;

    public IntervalMatcher(Number floor, Number ceiling, boolean floorIsGreaterThan, boolean ceilingIsLessThan) {
        this.floor = floor;
        this.ceiling = ceiling;
        this.floorIsGreaterThan = floorIsGreaterThan;
        this.ceilingIsLessThan = ceilingIsLessThan;
    }

    protected int compareTo(Number other, Number edge, int defaultValue) {
        if (edge == null) {
            return defaultValue;
        }
        double dOther = other.doubleValue();
        double dEdge = edge.doubleValue();
        return Double.compare(dOther, dEdge);
    }

    protected boolean matchByType(Number other) {
        boolean isInRange;
        boolean bl = isInRange = this.floor == null;
        if (!isInRange) {
            int floorCompare = this.compareTo(other, this.floor, 1);
            if (this.floorIsGreaterThan && floorCompare > 0 || !this.floorIsGreaterThan && floorCompare >= 0) {
                boolean bl2 = isInRange = this.ceiling == null;
                if (!isInRange) {
                    int ceilingCompare = this.compareTo(other, this.ceiling, -1);
                    if (this.ceilingIsLessThan && ceilingCompare < 0 || !this.ceilingIsLessThan && ceilingCompare <= 0) {
                        isInRange = true;
                    }
                }
            }
        }
        return isInRange;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.floorIsGreaterThan ? "(" : "[");
        builder.append(this.floor).append(",").append(this.ceiling);
        builder.append(this.ceilingIsLessThan ? ")" : "]");
        return builder.toString();
    }
}

