/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.AbstractJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.CacheListenerBase;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.jboss.cache.notifications.annotation.CacheListener
public class CacheListener
extends CacheListenerBase {
    private static final int POJO_ATTRIBUTE_FQN_INDEX = 3;
    private static final int POJO_KEY_FQN_INDEX = 4;
    private static final int POJO_INTERNAL_FQN_INDEX = 3;
    private static final int POJO_INTERNAL_FQN_SIZE = 4;
    private static Logger log_ = Logger.getLogger(CacheListener.class);
    private boolean attributeBased_;
    private boolean fieldBased_;

    CacheListener(JBossCacheWrapper wrapper, LocalDistributableSessionManager manager, String contextHostPath, ReplicationGranularity granularity) {
        super(manager, contextHostPath);
        if (granularity == ReplicationGranularity.FIELD) {
            this.fieldBased_ = true;
        } else if (granularity == ReplicationGranularity.ATTRIBUTE) {
            this.attributeBased_ = true;
        }
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        boolean local = event.isOriginLocal();
        if (!this.fieldBased_ && local) {
            return;
        }
        Fqn fqn = event.getFqn();
        boolean isBuddy = CacheListener.isBuddyFqn((Fqn<String>)fqn);
        if (!local && CacheListener.isFqnSessionRootSized((Fqn<String>)fqn, isBuddy) && this.isFqnForOurWebapp((Fqn<String>)fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn((Fqn<String>)fqn, isBuddy);
            this.manager_.notifyRemoteInvalidation(sessId);
        } else if (local && !isBuddy && CacheListener.isPossibleInternalPojoFqn((Fqn<String>)fqn) && this.isFqnForOurWebapp((Fqn<String>)fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn((Fqn<String>)fqn, isBuddy);
            this.manager_.notifyLocalAttributeModification(sessId);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (event.isPre()) {
            return;
        }
        boolean local = event.isOriginLocal();
        if (!this.fieldBased_ && local) {
            return;
        }
        Fqn fqn = event.getFqn();
        boolean isBuddy = CacheListener.isBuddyFqn((Fqn<String>)fqn);
        if (!local && CacheListener.isFqnSessionRootSized((Fqn<String>)fqn, isBuddy) && this.isFqnForOurWebapp((Fqn<String>)fqn, isBuddy)) {
            Map data = event.getData();
            Integer version = (Integer)data.get(AbstractJBossCacheService.VERSION_KEY);
            if (version != null) {
                String realId = CacheListener.getIdFromFqn((Fqn<String>)fqn, isBuddy);
                String owner = isBuddy ? CacheListener.getBuddyOwner((Fqn<String>)fqn) : null;
                Long timestamp = (Long)data.get(AbstractJBossCacheService.TIMESTAMP_KEY);
                if (timestamp == null) {
                    log_.warn((Object)("No timestamp attribute found in " + fqn));
                } else {
                    boolean updated = this.manager_.sessionChangedInDistributedCache(realId, owner, version.intValue(), timestamp.longValue(), (DistributableSessionMetadata)data.get(AbstractJBossCacheService.METADATA_KEY));
                    if (!updated && !isBuddy) {
                        log_.warn((Object)("Possible concurrency problem: Replicated version id " + version + " is less than or equal to in-memory version for session " + realId));
                    }
                }
            } else if (!this.attributeBased_) {
                log_.warn((Object)("No version attribute found in " + fqn));
            }
        } else if (local && !isBuddy && CacheListener.isPossibleInternalPojoFqn((Fqn<String>)fqn) && this.isFqnForOurWebapp((Fqn<String>)fqn, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn((Fqn<String>)fqn, isBuddy);
            this.manager_.notifyLocalAttributeModification(sessId);
        }
    }

    public static String getPojoKeyFromFqn(Fqn<String> fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 4 : 4);
    }

    public static boolean isPossibleInternalPojoFqn(Fqn<String> fqn) {
        return fqn.size() > 4 && !"ATTRIBUTE".equals(fqn.get(3));
    }
}

