/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.ejb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ejb.EJB;
import javax.inject.ExecutionException;
import javax.inject.manager.InjectionPoint;
import javax.naming.NamingException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.integration.ejb.JBossEJBDescriptorAdaptor;
import org.jboss.webbeans.integration.ejb.JBossMessageDrivenBeanDescriptorAdaptor;
import org.jboss.webbeans.integration.ejb.JBossSessionBeanDescriptorAdaptor;
import org.jboss.webbeans.integration.ejb.JBossSessionObjectReference;
import org.jboss.webbeans.integration.util.AbstractJBossServices;
import org.jboss.webbeans.integration.vdf.DeploymentUnitAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossEjbServices
extends AbstractJBossServices
implements EjbServices,
DeploymentUnitAware {
    protected EjbReferenceResolver resolver;
    private final List<EjbDescriptor<?>> ejbs = new ArrayList();
    private final List<String> ejbContainerNames = new ArrayList<String>();

    public void setResolver(EjbReferenceResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit du) {
        super.setDeploymentUnit(du);
        this.discoverEjbs(du.getTopLevel());
    }

    public Object resolveEjb(InjectionPoint injectionPoint) {
        String jndiName;
        if (!injectionPoint.isAnnotationPresent(EJB.class)) {
            throw new IllegalArgumentException("No @EJB annotation found on injection point " + injectionPoint);
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        EJB annotation = (EJB)injectionPoint.getAnnotation(EJB.class);
        String beanName = annotation.beanName();
        String beanInterface = annotation.beanInterface().getName();
        String mappedName = annotation.mappedName();
        if (beanInterface == null || beanInterface.equals(Object.class.getName())) {
            if (injectionPoint.getMember() instanceof Field && injectionPoint.getType() instanceof Class) {
                beanInterface = ((Class)injectionPoint.getType()).getName();
            } else if (injectionPoint.getMember() instanceof Method) {
                Method method = (Method)injectionPoint.getMember();
                beanInterface = method.getParameterTypes()[0].getName();
            }
        }
        if ((jndiName = this.resolver.resolveEjb(this.topLevelDeploymentUnit, new EjbReference(beanName, beanInterface, null))) == null) {
            throw new IllegalStateException("No EJBs available which can be injected into " + injectionPoint);
        }
        try {
            return this.context.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new ExecutionException("Error retreiving EJB from JNDI for injection point " + injectionPoint, (Throwable)e);
        }
    }

    public SessionObjectReference resolveEjb(EjbDescriptor<?> ejbDescriptor) {
        try {
            return new JBossSessionObjectReference(ejbDescriptor, this.context);
        }
        catch (NamingException e) {
            throw new ExecutionException("Error retreiving EJB from JNDI " + ejbDescriptor, (Throwable)e);
        }
    }

    public Object resolveRemoteEjb(String jndiName, String mappedName, String ejbLink) {
        if (mappedName != null) {
            try {
                return this.context.lookup(mappedName);
            }
            catch (NamingException e) {
                throw new ExecutionException("Error retreiving EJB from JNDI with mappedName " + mappedName, (Throwable)e);
            }
        }
        if (jndiName != null) {
            try {
                return this.context.lookup(jndiName);
            }
            catch (NamingException e) {
                throw new ExecutionException("Error retreiving EJB from JNDI with mappedName " + jndiName, (Throwable)e);
            }
        }
        throw new IllegalArgumentException("jndiName, mappedName and ejbLink are null");
    }

    protected void discoverEjbs(DeploymentUnit du) {
        List children;
        if (du.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class) != null && ((JBossMetaData)du.getAttachment(JBossMetaData.class)).isEJB3x()) {
            for (JBossEnterpriseBeanMetaData enterpriseBeanMetaData : ((JBossMetaData)du.getAttachment(JBossMetaData.class)).getEnterpriseBeans()) {
                JBossEJBDescriptorAdaptor ejbDescriptor;
                if (enterpriseBeanMetaData.isSession()) {
                    JBossSessionBeanMetaData sessionBeanMetaData = (JBossSessionBeanMetaData)enterpriseBeanMetaData;
                    ejbDescriptor = new JBossSessionBeanDescriptorAdaptor(sessionBeanMetaData, du, this.resolver);
                    this.ejbs.add(ejbDescriptor);
                } else if (enterpriseBeanMetaData.isMessageDriven()) {
                    JBossMessageDrivenBeanMetaData messageDrivenBeanMetaData = (JBossMessageDrivenBeanMetaData)enterpriseBeanMetaData;
                    ejbDescriptor = new JBossMessageDrivenBeanDescriptorAdaptor(messageDrivenBeanMetaData, du, this.resolver);
                    this.ejbs.add(ejbDescriptor);
                }
                if (enterpriseBeanMetaData.getContainerName() != null) {
                    this.ejbContainerNames.add(enterpriseBeanMetaData.getContainerName());
                    continue;
                }
                this.ejbContainerNames.add(enterpriseBeanMetaData.getGeneratedContainerName());
            }
        }
        if ((children = du.getChildren()) != null && !children.isEmpty()) {
            for (DeploymentUnit childDu : children) {
                this.discoverEjbs(childDu);
            }
        }
    }

    public Iterable<EjbDescriptor<?>> discoverEjbs() {
        return this.ejbs;
    }

    public Iterable<String> getEjbContainerNames() {
        return Collections.unmodifiableCollection(this.ejbContainerNames);
    }
}

