/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.tools.io.NullPrintStream;
import org.jboss.ws.tools.jaxws.impl.BytecodeWrapperGenerator;
import org.jboss.ws.tools.jaxws.impl.ChainedWritableWrapperGenerator;
import org.jboss.ws.tools.jaxws.impl.SourceWrapperGenerator;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.tools.WSContractProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JBossWSProviderImpl
extends WSContractProvider {
    private ClassLoader loader;
    private boolean generateWsdl = false;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File resourceDir = null;
    private File sourceDir = null;
    private PrintStream messageStream = NullPrintStream.getInstance();

    JBossWSProviderImpl() {
    }

    private void createDirectories(File resourceDir, File sourceDir) {
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new WSException("Could not create directory: " + this.outputDir);
        }
        if (this.generateWsdl && !resourceDir.exists() && !resourceDir.mkdirs()) {
            throw new WSException("Could not create directory: " + resourceDir);
        }
        if (this.generateSource && !sourceDir.exists() && !sourceDir.mkdirs()) {
            throw new WSException("Could not create directory: " + sourceDir);
        }
    }

    public void provide(Class<?> endpointClass) {
        File resourceDir = this.resourceDir != null ? this.resourceDir : this.outputDir;
        File sourceDir = this.sourceDir != null ? this.sourceDir : this.outputDir;
        this.createDirectories(resourceDir, sourceDir);
        this.messageStream.println("Output directory: " + this.outputDir.getAbsolutePath());
        this.messageStream.println("Source directory: " + sourceDir.getAbsolutePath());
        URLClassLoader loader = new URLClassLoader(new URL[0], this.loader);
        UnifiedMetaData umd = new UnifiedMetaData((UnifiedVirtualFile)new ResourceLoaderAdapter((ClassLoader)loader));
        umd.setClassLoader(loader);
        ChainedWritableWrapperGenerator generator = new ChainedWritableWrapperGenerator();
        if (this.generateSource) {
            generator.add(new SourceWrapperGenerator(loader, this.messageStream), sourceDir);
        }
        generator.add(new BytecodeWrapperGenerator(loader, this.messageStream), this.outputDir);
        JAXWSWebServiceMetaDataBuilder builder = new JAXWSWebServiceMetaDataBuilder();
        builder.setWrapperGenerator(generator);
        builder.setGenerateWsdl(this.generateWsdl);
        builder.setToolMode(true);
        builder.setWsdlDirectory(resourceDir);
        builder.setMessageStream(this.messageStream);
        if (this.generateWsdl) {
            this.messageStream.println("Generating WSDL:");
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        DeploymentModelFactory factory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
        Deployment dep = factory.newDeployment("wsprovide-deployment", (ClassLoader)loader);
        dep.setRuntimeClassLoader((ClassLoader)loader);
        builder.buildWebServiceMetaData(dep, umd, endpointClass, null);
        try {
            generator.write();
        }
        catch (IOException io) {
            throw new WSException("Could not write output files:", io);
        }
    }

    public void provide(String endpointClass) {
        try {
            this.provide(this.loader.loadClass(endpointClass));
        }
        catch (ClassNotFoundException e) {
            throw new WSException("Class not found: " + endpointClass);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setGenerateWsdl(boolean generateWsdl) {
        this.generateWsdl = generateWsdl;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setResourceDirectory(File directory) {
        this.resourceDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }
}

