/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AFM {
    private static final Logger logger = Logger.getLogger(AFM.class.toString());
    public static final int COURIER = 0;
    public static final int COURIER_BOLD = 1;
    public static final int COURIER_OBLIQUE = 2;
    public static final int COURIER_BOLD_OBLIQUE = 3;
    public static final int HELVETICA = 4;
    public static final int HELVETICA_BOLD = 5;
    public static final int HELVETICA_OBLIQUE = 6;
    public static final int HELVETICA_BOLD_OBLIQUE = 7;
    public static final int TIMES_ROMAN = 8;
    public static final int TIMES_BOLD = 9;
    public static final int TIMES_ITALIC = 10;
    public static final int TIMES_BOLD_ITALIC = 11;
    public static final int ZAPF_DINGBATS = 12;
    public static final int SYMBOL = 13;
    public static String[] AFMnames = new String[]{"Courier.afm", "Courier-Bold.afm", "Courier-Oblique.afm", "Courier-BoldOblique.afm", "Helvetica.afm", "Helvetica-Bold.afm", "Helvetica-Oblique.afm", "Helvetica-BoldOblique.afm", "Times-Roman.afm", "Times-Bold.afm", "Times-Italic.afm", "Times-BoldItalic.afm", "ZapfDingbats.afm", "Symbol.afm"};
    private static int[] AFMFlags = new int[]{35, 35, 99, 99, 32, 32, 96, 96, 34, 34, 98, 98, 4, 4};
    public static HashMap<String, AFM> AFMs = new HashMap(14);
    private String fontName;
    private String familyName;
    private String fullName;
    private float[] widths = new float[255];
    private int[] fontBBox = new int[4];
    private float italicAngle = 0.0f;
    private int maxWidth = 0;
    private int avgWidth = 0;
    private int flags = 0;

    public AFM(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            this.parse(new InputStreamReader(inputStream));
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Could not find AFM File: " + string);
        }
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int[] getFontBBox() {
        return this.fontBBox;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public float[] getWidths() {
        return this.widths;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getAvgWidth() {
        return this.avgWidth;
    }

    public int getFlags() {
        return this.flags;
    }

    private void setFlags(int n) {
        this.flags = n;
    }

    private void parse(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        int n = 0;
        this.avgWidth = 0;
        this.maxWidth = 0;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ;\t\n\r\f");
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("FontName")) {
                this.fontName = stringTokenizer.nextToken();
                continue;
            }
            if (string2.equalsIgnoreCase("FullName")) {
                this.fullName = stringTokenizer.nextToken();
                continue;
            }
            if (string2.equalsIgnoreCase("FamilyName")) {
                this.familyName = stringTokenizer.nextToken();
                continue;
            }
            if (string2.equalsIgnoreCase("FontBBox")) {
                this.fontBBox[0] = new Integer(stringTokenizer.nextToken());
                this.fontBBox[1] = new Integer(stringTokenizer.nextToken());
                this.fontBBox[2] = new Integer(stringTokenizer.nextToken());
                this.fontBBox[3] = new Integer(stringTokenizer.nextToken());
                continue;
            }
            if (string2.equalsIgnoreCase("ItalicAngle")) {
                this.italicAngle = new Float(stringTokenizer.nextToken()).floatValue();
                continue;
            }
            if (!string2.equalsIgnoreCase("C")) continue;
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            while (!stringTokenizer.nextToken().equals("WX")) {
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 < 0 || n2 >= 255) continue;
            this.widths[n] = n3;
            if (n3 > this.maxWidth) {
                this.maxWidth = n3;
            }
            this.avgWidth += n3;
            ++n;
        }
        this.avgWidth /= n;
    }

    static {
        try {
            for (int i = 0; i < AFMnames.length; ++i) {
                AFM aFM = new AFM("afm/" + AFMnames[i]);
                aFM.setFlags(AFMFlags[i]);
                AFMs.put(aFM.fontName.toLowerCase(), aFM);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

