/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.jmx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerLocator;

public abstract class JDBCServiceSupport
extends ServiceMBeanSupport {
    protected DataSource ds;
    protected Properties sqlProperties;
    protected boolean createTablesOnStartup = true;
    private String dataSourceJNDIName;
    private ObjectName tmObjectName;
    private TransactionManager tm;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startService() throws Exception {
        InitialContext ic = null;
        try {
            try {
                ic = new InitialContext();
                if (this.dataSourceJNDIName != null) {
                    this.ds = (DataSource)ic.lookup(this.dataSourceJNDIName);
                    if (this.ds == null) {
                        throw new IllegalStateException("No DataSource found. This service dependencies must have not been enforced correctly!");
                    }
                }
                Object var4_2 = null;
                if (ic == null) return;
            }
            catch (Throwable t) {
                throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " startService");
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (ic == null) throw throwable;
            ic.close();
            throw throwable;
        }
        ic.close();
    }

    protected void stopService() throws Exception {
        this.log.debug((Object)((Object)((Object)this) + " stopped"));
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException shouldnothappen) {
            this.log.error((Object)"Caught IOException", (Throwable)shouldnothappen);
        }
    }

    public void setDataSource(String dataSourceJNDIName) throws Exception {
        this.dataSourceJNDIName = dataSourceJNDIName;
    }

    public String getDataSource() {
        return this.dataSourceJNDIName;
    }

    public void setTransactionManager(ObjectName tmObjectName) throws Exception {
        this.tmObjectName = tmObjectName;
    }

    public ObjectName getTransactionManager() {
        return this.tmObjectName;
    }

    public boolean isCreateTablesOnStartup() throws Exception {
        return this.createTablesOnStartup;
    }

    public void setCreateTablesOnStartup(boolean b) throws Exception {
        this.createTablesOnStartup = b;
    }

    protected TransactionManager getTransactionManagerReference() {
        if (this.tm == null) {
            this.tm = TransactionManagerLocator.getInstance().locate();
        }
        return this.tm;
    }
}

