/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class MeasurementData
implements Serializable {
    @EmbeddedId
    MeasurementDataPK id;
    @JoinColumn(name="SCHEDULE_ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    MeasurementSchedule schedule;
    @Transient
    private String name;

    protected MeasurementData() {
        this(new MeasurementDataPK(System.currentTimeMillis(), 0));
    }

    protected MeasurementData(MeasurementDataPK pk) {
        if (pk == null) {
            throw new NullPointerException("pk==null");
        }
        this.id = pk;
    }

    protected MeasurementData(long timestamp, MeasurementScheduleRequest request) {
        this(new MeasurementDataPK(timestamp, request.getScheduleId()));
        this.setName(request.getName());
    }

    protected MeasurementData(MeasurementScheduleRequest request) {
        this(new MeasurementDataPK(System.currentTimeMillis(), request.getScheduleId()));
        this.setName(request.getName());
    }

    public int getScheduleId() {
        return this.id.scheduleId;
    }

    public long getTimestamp() {
        return this.id.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract Object getValue();

    public String toString() {
        return "MeasurementData [" + this.id + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MeasurementData)) {
            return false;
        }
        MeasurementData that = (MeasurementData)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

