/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.VersionType;
import org.jboss.seam.Component;
import org.jboss.seam.Entity;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.Filter;
import org.jboss.seam.persistence.HibernateSessionProxy;
import org.jboss.seam.persistence.PersistenceProvider;

@Name(value="org.jboss.seam.persistence.persistenceProvider")
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Install(precedence=10, classDependencies={"org.hibernate.Session", "javax.persistence.EntityManager"})
public class HibernatePersistenceProvider
extends PersistenceProvider {
    private static Log log = Logging.getLog(HibernatePersistenceProvider.class);
    private static Constructor FULL_TEXT_SESSION_PROXY_CONSTRUCTOR;
    private static Method FULL_TEXT_SESSION_CONSTRUCTOR;
    private static Constructor FULL_TEXT_ENTITYMANAGER_PROXY_CONSTRUCTOR;
    private static Method FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR;

    static Session proxySession(Session session) {
        if (FULL_TEXT_SESSION_PROXY_CONSTRUCTOR == null) {
            return new HibernateSessionProxy(session);
        }
        try {
            return (Session)FULL_TEXT_SESSION_PROXY_CONSTRUCTOR.newInstance(FULL_TEXT_SESSION_CONSTRUCTOR.invoke(null, session));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to wrap into a FullTextSessionProxy, regular SessionProxy returned", e, new Object[0]);
            return new HibernateSessionProxy(session);
        }
    }

    public Object proxyDelegate(Object delegate) {
        try {
            return HibernatePersistenceProvider.proxySession((Session)delegate);
        }
        catch (NotHibernateException nhe) {
            return super.proxyDelegate(delegate);
        }
        catch (Exception e) {
            throw new RuntimeException("could not proxy delegate", e);
        }
    }

    public void setFlushModeManual(EntityManager entityManager) {
        try {
            this.getSession(entityManager).setFlushMode(FlushMode.MANUAL);
        }
        catch (NotHibernateException nhe) {
            super.setFlushModeManual(entityManager);
        }
    }

    public boolean isDirty(EntityManager entityManager) {
        try {
            return this.getSession(entityManager).isDirty();
        }
        catch (NotHibernateException nhe) {
            return super.isDirty(entityManager);
        }
    }

    public Object getId(Object bean, EntityManager entityManager) {
        try {
            return this.getSession(entityManager).getIdentifier(bean);
        }
        catch (NotHibernateException nhe) {
            return super.getId(bean, entityManager);
        }
        catch (TransientObjectException e) {
            if (bean instanceof HibernateProxy) {
                return super.getId(((HibernateProxy)bean).getHibernateLazyInitializer().getImplementation(), entityManager);
            }
            return super.getId(bean, entityManager);
        }
    }

    public Object getVersion(Object bean, EntityManager entityManager) {
        try {
            return HibernatePersistenceProvider.getVersion(bean, this.getSession(entityManager));
        }
        catch (NotHibernateException nhe) {
            return super.getVersion(bean, entityManager);
        }
    }

    public void checkVersion(Object bean, EntityManager entityManager, Object oldVersion, Object version) {
        try {
            HibernatePersistenceProvider.checkVersion(bean, this.getSession(entityManager), oldVersion, version);
        }
        catch (NotHibernateException nhe) {
            super.checkVersion(bean, entityManager, oldVersion, version);
        }
    }

    public void enableFilter(Filter f, EntityManager entityManager) {
        try {
            org.hibernate.Filter filter = this.getSession(entityManager).enableFilter(f.getName());
            for (Map.Entry<String, Expressions.ValueExpression> me : f.getParameters().entrySet()) {
                Object filterValue = me.getValue().getValue();
                if (filterValue instanceof Collection) {
                    filter.setParameterList(me.getKey(), (Collection)filterValue);
                    continue;
                }
                filter.setParameter(me.getKey(), filterValue);
            }
            filter.validate();
        }
        catch (NotHibernateException nhe) {
            super.enableFilter(f, entityManager);
        }
    }

    public boolean registerSynchronization(Synchronization sync, EntityManager entityManager) {
        try {
            this.getSession(entityManager).getTransaction().registerSynchronization(sync);
            return true;
        }
        catch (NotHibernateException nhe) {
            return super.registerSynchronization(sync, entityManager);
        }
    }

    public String getName(Object bean, EntityManager entityManager) throws IllegalArgumentException {
        try {
            return this.getSession(entityManager).getEntityName(bean);
        }
        catch (NotHibernateException nhe) {
            return super.getName(bean, entityManager);
        }
        catch (TransientObjectException e) {
            return super.getName(bean, entityManager);
        }
    }

    public EntityManager proxyEntityManager(EntityManager entityManager) {
        if (FULL_TEXT_ENTITYMANAGER_PROXY_CONSTRUCTOR == null) {
            return super.proxyEntityManager(entityManager);
        }
        try {
            return (EntityManager)FULL_TEXT_ENTITYMANAGER_PROXY_CONSTRUCTOR.newInstance(FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR.invoke(null, super.proxyEntityManager(entityManager)));
        }
        catch (Exception e) {
            return super.proxyEntityManager(entityManager);
        }
    }

    public static void checkVersion(Object value, Session session, Object oldVersion, Object version) {
        ClassMetadata classMetadata = HibernatePersistenceProvider.getClassMetadata(value, session);
        VersionType versionType = (VersionType)classMetadata.getPropertyTypes()[classMetadata.getVersionProperty()];
        if (!versionType.isEqual(oldVersion, version)) {
            throw new StaleStateException("current database version number does not match passivated version number");
        }
    }

    public static Object getVersion(Object value, Session session) {
        ClassMetadata classMetadata = HibernatePersistenceProvider.getClassMetadata(value, session);
        return classMetadata != null && classMetadata.isVersioned() ? classMetadata.getVersion(value, EntityMode.POJO) : null;
    }

    private static ClassMetadata getClassMetadata(Object value, Session session) {
        Class entityClass = HibernatePersistenceProvider.getEntityClass(value);
        ClassMetadata classMetadata = null;
        if (entityClass != null && (classMetadata = session.getSessionFactory().getClassMetadata(entityClass)) == null) {
            throw new IllegalArgumentException("Could not find ClassMetadata object for entity class: " + entityClass.getName());
        }
        return classMetadata;
    }

    public Class getBeanClass(Object bean) {
        return HibernatePersistenceProvider.getEntityClass(bean);
    }

    public static Class getEntityClass(Object bean) {
        Class clazz = null;
        try {
            clazz = Entity.forBean(bean).getBeanClass();
        }
        catch (Entity.NotEntityException notEntityException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Hibernate.getClass((Object)bean);
        }
        return clazz;
    }

    private Session getSession(EntityManager entityManager) {
        Object delegate = entityManager.getDelegate();
        if (delegate instanceof Session) {
            return (Session)delegate;
        }
        throw new NotHibernateException();
    }

    public static HibernatePersistenceProvider instance() {
        return (HibernatePersistenceProvider)Component.getInstance(HibernatePersistenceProvider.class, ScopeType.STATELESS);
    }

    static {
        try {
            String version = null;
            try {
                Class<?> searchVersionClass = Class.forName("org.hibernate.search.Version");
                Field versionField = searchVersionClass.getDeclaredField("VERSION");
                version = (String)versionField.get(null);
            }
            catch (Exception e) {
                log.debug((Object)"no Hibernate Search, sorry :-(", e, new Object[0]);
            }
            if (version != null) {
                Class<?> searchClass = Class.forName("org.hibernate.search.Search");
                FULL_TEXT_SESSION_CONSTRUCTOR = searchClass.getDeclaredMethod("createFullTextSession", Session.class);
                Class<?> fullTextSessionProxyClass = Class.forName("org.jboss.seam.persistence.FullTextHibernateSessionProxy");
                Class<?> fullTextSessionClass = Class.forName("org.hibernate.search.FullTextSession");
                FULL_TEXT_SESSION_PROXY_CONSTRUCTOR = fullTextSessionProxyClass.getDeclaredConstructor(fullTextSessionClass);
                Class<?> jpaSearchClass = Class.forName("org.hibernate.search.jpa.Search");
                FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR = jpaSearchClass.getDeclaredMethod("createFullTextEntityManager", EntityManager.class);
                Class<?> fullTextEntityManagerProxyClass = Class.forName("org.jboss.seam.persistence.FullTextEntityManagerProxy");
                Class<?> fullTextEntityManagerClass = Class.forName("org.hibernate.search.jpa.FullTextEntityManager");
                FULL_TEXT_ENTITYMANAGER_PROXY_CONSTRUCTOR = fullTextEntityManagerProxyClass.getDeclaredConstructor(fullTextEntityManagerClass);
                log.debug((Object)"Hibernate Search is available :-)", new Object[0]);
            }
        }
        catch (Exception e) {
            log.debug((Object)"no Hibernate Search, sorry :-(", e, new Object[0]);
        }
    }

    static class NotHibernateException
    extends IllegalArgumentException {
        NotHibernateException() {
        }
    }
}

