/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.ObjectFilter;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.base.ClassObjectFilter;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.permission.PermissionCheck;
import org.jboss.seam.security.permission.PermissionResolver;
import org.jboss.seam.security.permission.RoleCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.ruleBasedPermissionResolver")
@Scope(value=ScopeType.SESSION)
@BypassInterceptors
@Install(precedence=0, classDependencies={"org.drools.WorkingMemory"})
@Startup
public class RuleBasedPermissionResolver
implements PermissionResolver,
Serializable {
    public static final String RULES_COMPONENT_NAME = "securityRules";
    private static final LogProvider log = Logging.getLogProvider(RuleBasedPermissionResolver.class);
    private StatefulSession securityContext;
    private RuleBase securityRules;

    @Create
    public boolean create() {
        this.initSecurityContext();
        return this.getSecurityContext() != null;
    }

    protected void initSecurityContext() {
        if (this.getSecurityRules() == null) {
            this.setSecurityRules((RuleBase)Component.getInstance(RULES_COMPONENT_NAME, true));
        }
        if (this.getSecurityRules() != null) {
            this.setSecurityContext(this.getSecurityRules().newStatefulSession(false));
        }
        if (this.getSecurityContext() == null) {
            log.debug("no security rule base available - please install a RuleBase with the name 'securityRules' if permission checks are required.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermission(Object target, String action) {
        PermissionCheck check;
        StatefulSession securityContext = this.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        StatefulSession statefulSession = securityContext;
        synchronized (statefulSession) {
            if (!(target instanceof String) && !(target instanceof Class)) {
                handles.add(securityContext.insert(target));
            } else if (target instanceof Class) {
                String componentName = Seam.getComponentName((Class)target);
                target = componentName != null ? componentName : ((Class)target).getName();
            }
            check = new PermissionCheck(target, action);
            try {
                this.synchronizeContext();
                handles.add(securityContext.insert((Object)check));
                securityContext.fireAllRules();
            }
            finally {
                for (FactHandle handle : handles) {
                    securityContext.retract(handle);
                }
            }
        }
        return check.isGranted();
    }

    @Override
    public void filterSetByAction(Set<Object> targets, String action) {
        Iterator<Object> iter = targets.iterator();
        while (iter.hasNext()) {
            Object target = iter.next();
            if (!this.hasPermission(target, action)) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConditionalRole(String roleName, Object target, String action) {
        StatefulSession securityContext = this.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        RoleCheck roleCheck = new RoleCheck(roleName);
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        PermissionCheck check = new PermissionCheck(target, action);
        StatefulSession statefulSession = securityContext;
        synchronized (statefulSession) {
            if (!(target instanceof String) && !(target instanceof Class)) {
                handles.add(securityContext.insert(target));
            } else if (target instanceof Class) {
                String componentName = Seam.getComponentName((Class)target);
                target = componentName != null ? componentName : ((Class)target).getName();
            }
            try {
                this.synchronizeContext();
                handles.add(securityContext.insert((Object)roleCheck));
                handles.add(securityContext.insert((Object)check));
                securityContext.fireAllRules();
            }
            finally {
                for (FactHandle handle : handles) {
                    securityContext.retract(handle);
                }
            }
        }
        return roleCheck.isGranted();
    }

    @Observer(value={"org.jboss.seam.security.loggedOut"})
    public void unAuthenticate() {
        if (this.getSecurityContext() != null) {
            this.getSecurityContext().dispose();
            this.setSecurityContext(null);
        }
        this.initSecurityContext();
    }

    private void synchronizeContext() {
        Identity identity = Identity.instance();
        this.getSecurityContext().insert((Object)identity.getPrincipal());
        if (this.getSecurityContext() != null) {
            for (Group sg : identity.getSubject().getPrincipals(Group.class)) {
                if (!"Roles".equals(sg.getName())) continue;
                Enumeration e = sg.members();
                while (e.hasMoreElements()) {
                    Principal role = (Principal)e.nextElement();
                    boolean found = false;
                    Iterator iter = this.getSecurityContext().iterateObjects((ObjectFilter)new ClassObjectFilter(Role.class));
                    while (iter.hasNext()) {
                        Role r = (Role)iter.next();
                        if (!r.getName().equals(role.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getSecurityContext().insert((Object)new Role(role.getName()));
                }
            }
            Iterator iter = this.getSecurityContext().iterateObjects((ObjectFilter)new ClassObjectFilter(Role.class));
            while (iter.hasNext()) {
                Role r = (Role)iter.next();
                if (identity.hasRole(r.getName())) continue;
                FactHandle fh = this.getSecurityContext().getFactHandle((Object)r);
                this.getSecurityContext().retract(fh);
            }
        }
    }

    public StatefulSession getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(StatefulSession securityContext) {
        this.securityContext = securityContext;
    }

    public RuleBase getSecurityRules() {
        return this.securityRules;
    }

    public void setSecurityRules(RuleBase securityRules) {
        this.securityRules = securityRules;
    }

    public static RuleBasedPermissionResolver instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        RuleBasedPermissionResolver instance = (RuleBasedPermissionResolver)Component.getInstance(RuleBasedPermissionResolver.class, ScopeType.SESSION);
        if (instance == null) {
            throw new IllegalStateException("No RuleBasedPermissionResolver could be created");
        }
        return instance;
    }

    @Observer(value={"org.jboss.seam.security.postAuthenticate"})
    public void setUserAccountInSecurityContext() {
        if (this.getSecurityContext() != null) {
            this.getSecurityContext().insert((Object)Identity.instance().getPrincipal());
            if (Contexts.isEventContextActive() && Contexts.isSessionContextActive() && Contexts.getEventContext().isSet("org.jboss.seam.security.management.authenticatedUser")) {
                this.getSecurityContext().insert(Contexts.getEventContext().get("org.jboss.seam.security.management.authenticatedUser"));
            }
        }
    }
}

