/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.OutputStream;
import org.icepdf.core.util.MemoryManager;

public class ConservativeSizingByteArrayOutputStream
extends OutputStream {
    protected MemoryManager memoryManager;
    protected byte[] buf;
    protected int count;

    public ConservativeSizingByteArrayOutputStream(int n, MemoryManager memoryManager) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial capacity: " + n);
        }
        this.memoryManager = memoryManager;
        this.buf = this.allocateByteArray(n, false);
        this.count = 0;
    }

    public ConservativeSizingByteArrayOutputStream(byte[] byArray, MemoryManager memoryManager) {
        if (byArray == null) {
            throw new IllegalArgumentException("Initial buffer is null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Initial buffer has zero length");
        }
        this.memoryManager = memoryManager;
        this.buf = byArray;
        this.count = 0;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public synchronized void write(int n) throws IOException {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            this.resizeArrayToFit(n2);
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n >= byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            this.resizeArrayToFit(n3);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = this.allocateByteArray(this.count, false);
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public synchronized byte[] relinquishByteArray() {
        byte[] byArray = this.buf;
        this.buf = null;
        this.buf = new byte[64];
        this.count = 0;
        return byArray;
    }

    public boolean trim() {
        if (this.count == 0 && (this.buf == null || this.buf.length == 0)) {
            return true;
        }
        if (this.count == this.buf.length) {
            return true;
        }
        byte[] byArray = this.allocateByteArray(this.count, true);
        if (byArray == null) {
            return false;
        }
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.buf = null;
        this.buf = byArray;
        return true;
    }

    protected void resizeArrayToFit(int n) {
        int n2 = this.buf.length;
        if (n2 == 0) {
            n2 = 64;
        } else if (n2 <= 1024) {
            n2 *= 4;
        } else if (n2 <= 4024) {
            n2 *= 2;
        } else if (n2 <= 0x200000) {
            n2 *= 2;
            n2 &= 0xFFFFF000;
        } else if (n2 <= 0x400000) {
            n2 = n2 * 3 / 2;
            n2 &= 0xFFFFF000;
        } else if (n2 <= 0xF00000) {
            n2 = n2 * 5 / 4;
            n2 &= 0xFFFFF000;
        } else {
            n2 += 0x300000;
            n2 &= 0xFFFFF000;
        }
        int n3 = Math.max(n2, n);
        byte[] byArray = this.allocateByteArray(n3, false);
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.buf = null;
        this.buf = byArray;
    }

    protected byte[] allocateByteArray(int n, boolean bl) {
        boolean bl2 = true;
        if (this.memoryManager != null && n >= 524288) {
            bl2 = this.memoryManager.checkMemory(n);
        }
        if (bl && !bl2) {
            return null;
        }
        return new byte[n];
    }
}

