/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.file;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.plugins.context.AbstractContextFactory;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.spi.VFSContext;

public class FileSystemContextFactory
extends AbstractContextFactory {
    public FileSystemContextFactory() {
        super("file", "vfsfile");
    }

    public VFSContext getVFS(URL root) throws IOException {
        try {
            return new FileSystemContext(FileSystemContextFactory.fromVFS(root));
        }
        catch (URISyntaxException e) {
            MalformedURLException ex = new MalformedURLException("non-URI compliant URL");
            ex.initCause(e);
            throw ex;
        }
    }

    public VFSContext getVFS(URI root) throws IOException {
        try {
            return new FileSystemContext(FileSystemContextFactory.fromVFS(root));
        }
        catch (URISyntaxException e) {
            MalformedURLException ex = new MalformedURLException("non-URI compliant URI");
            ex.initCause(e);
            throw ex;
        }
    }
}

