/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.context.CreationalContext;
import javax.event.Observes;
import javax.inject.CreationException;
import javax.inject.DefinitionException;
import javax.inject.Disposes;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.DependentStorageRequest;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethodBean<T>
extends AbstractProducerBean<T, Method> {
    private MethodInjectionPoint<T> method;
    private DisposalMethodBean<?> disposalMethodBean;
    private ProducerMethodBean<?> specializedBean;
    private final String id;

    public static <T> ProducerMethodBean<T> of(AnnotatedMethod<T> method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        return new ProducerMethodBean<T>(method, declaringBean, manager);
    }

    protected ProducerMethodBean(AnnotatedMethod<T> method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        super(declaringBean, manager);
        this.method = MethodInjectionPoint.of(this, method);
        this.initType();
        this.initTypes();
        this.initBindings();
        this.id = ProducerMethodBean.createId("ProducerMethod-" + declaringBean.getType().getName() + "-" + method.getSignature().toString());
    }

    @Override
    protected T produceInstance(CreationalContext<T> creationalContext) {
        Object receiver = this.getReceiver(creationalContext);
        if (receiver != null) {
            return this.method.invokeOnInstance(receiver, this.manager, creationalContext, CreationException.class);
        }
        return this.method.invoke(receiver, this.manager, creationalContext, CreationException.class);
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.checkProducerMethod();
            this.initDisposalMethod(environment);
            this.initInjectionPoints();
        }
    }

    protected void initInjectionPoints() {
        for (ParameterInjectionPoint<?> parameter : this.method.getParameters()) {
            this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
        }
    }

    protected void checkProducerMethod() {
        if (this.getAnnotatedItem().getAnnotatedParameters(Observes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Observes");
        }
        if (this.getAnnotatedItem().getAnnotatedParameters(Disposes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Disposes");
        }
        if (this.declaringBean instanceof EnterpriseBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.declaringBean.getTypes()) {
                if (!(type instanceof Class)) continue;
                Class clazz = (Class)type;
                try {
                    clazz.getDeclaredMethod(this.getAnnotatedItem().getName(), this.getAnnotatedItem().getParameterTypesAsArray());
                    methodDeclaredOnTypes = true;
                }
                catch (NoSuchMethodException nsme) {}
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException("Producer method " + this.toString() + " must be declared on a business interface of " + (Object)((Object)this.declaringBean));
            }
        }
    }

    protected void initDisposalMethod(BeanDeployerEnvironment environment) {
        Set disposalBeans = this.manager.resolveDisposalBeans(this.getType(), this.bindings.toArray(new Annotation[0]));
        if (disposalBeans.size() == 1) {
            this.disposalMethodBean = disposalBeans.iterator().next();
            environment.addResolvedDisposalBean(this.disposalMethodBean);
        } else if (disposalBeans.size() > 1) {
            throw new DefinitionException("Cannot declare multiple disposal methods for this producer method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance) {
        DependentStorageRequest dependentStorageRequest = DependentStorageRequest.of(this.dependentInstancesStore, new Object());
        try {
            if (this.getDeclaringBean().isDependent()) {
                DependentContext.instance().startCollectingDependents(dependentStorageRequest);
            }
            DependentContext.instance().setActive(true);
            if (this.disposalMethodBean != null) {
                this.disposalMethodBean.invokeDisposeMethod(instance);
            }
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                DependentContext.instance().stopCollectingDependents(dependentStorageRequest);
                this.dependentInstancesStore.destroyDependentInstances(dependentStorageRequest.getKey());
            }
            DependentContext.instance().setActive(false);
        }
    }

    @Override
    public AnnotatedMethod<T> getAnnotatedItem() {
        return this.method;
    }

    @Override
    protected String getDefaultName() {
        return this.method.getPropertyName();
    }

    public DisposalMethodBean<?> getDisposalMethod() {
        return this.disposalMethodBean;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed producer method bean");
        } else {
            buffer.append("simple producer method bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "] ");
        buffer.append("API types " + this.getTypes() + ", binding types " + this.getBindings());
        return buffer.toString();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        if (this.declaringBean.getAnnotatedItem().getSuperclass().getDeclaredMethod(this.getAnnotatedItem().getAnnotatedMethod()) == null) {
            throw new DefinitionException("Specialized producer method does not override a method on the direct superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        AnnotatedMethod<?> superClassMethod = this.declaringBean.getAnnotatedItem().getSuperclass().getMethod(this.getAnnotatedItem().getAnnotatedMethod());
        if (environment.getProducerMethod(superClassMethod) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        this.specializedBean = environment.getProducerMethod(superClassMethod);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

