/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.ObjectName;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.Invoker;
import org.jboss.logging.Logger;
import org.jboss.proxy.ClientContainer;
import org.jboss.proxy.ClientContainerEx;
import org.jboss.proxy.IClientContainer;
import org.jboss.proxy.Interceptor;
import org.jboss.system.Registry;
import org.jboss.util.NestedRuntimeException;

public class GenericProxyFactory {
    private static final Logger log = Logger.getLogger(GenericProxyFactory.class);

    public Object createProxy(Object id, ObjectName targetName, Invoker invoker, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces) {
        return this.createProxy(id, targetName, invoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces, null);
    }

    public Object createProxy(Object id, ObjectName targetName, ObjectName invokerName, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces) {
        Invoker invoker = (Invoker)Registry.lookup((Object)invokerName);
        if (invoker == null) {
            throw new RuntimeException("Failed to find invoker for name: " + invokerName);
        }
        return this.createProxy(id, targetName, invoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces, null);
    }

    public Object createProxy(Object id, ObjectName targetName, Invoker invoker, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces, HashMap ctx) {
        InvocationContext context = ctx != null ? new InvocationContext(ctx) : new InvocationContext();
        Integer nameHash = new Integer(targetName.hashCode());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Target name " + targetName + " and corresponding hash code" + nameHash));
        }
        context.setObjectName(nameHash);
        context.setCacheId(id);
        if (jndiName != null) {
            context.setValue(InvocationKey.JNDI_NAME, jndiName);
        }
        if (invoker == null) {
            throw new RuntimeException("Null invoker given for name: " + targetName);
        }
        context.setInvoker(invoker);
        if (proxyBindingName != null) {
            context.setInvokerProxyBinding(proxyBindingName);
        }
        boolean wantIClientAccess = false;
        for (int n = 0; !wantIClientAccess && n < interceptorClasses.size(); ++n) {
            Class type = (Class)interceptorClasses.get(n);
            wantIClientAccess = type.isAssignableFrom(IClientContainer.class);
        }
        ClientContainer client = wantIClientAccess ? new ClientContainerEx(context) : new ClientContainer(context);
        try {
            this.loadInterceptorChain(interceptorClasses, client);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Failed to load interceptor chain", (Throwable)e);
        }
        ArrayList<Class> tmp = new ArrayList<Class>(Arrays.asList(ifaces));
        Class[] ifaces2 = new Class[tmp.size()];
        tmp.toArray(ifaces2);
        return Proxy.newProxyInstance(loader, ifaces2, (InvocationHandler)client);
    }

    protected void loadInterceptorChain(ArrayList chain, ClientContainer client) throws Exception {
        Interceptor last = null;
        for (int i = 0; i < chain.size(); ++i) {
            Class clazz = (Class)chain.get(i);
            Interceptor interceptor = (Interceptor)clazz.newInstance();
            if (last == null) {
                last = interceptor;
                client.setNext(interceptor);
                continue;
            }
            last.setNext(interceptor);
            last = interceptor;
        }
    }
}

