/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.fckeditor;

import java.security.AccessControlException;
import javax.jcr.Node;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FCKUtils {
    public static String GET_FOLDERS_AND_FILES = "getFoldersAndFiles".intern();
    public static String CREATE_FOLDER = "createFolder".intern();
    public static String UPLOAD_FILE = "upload".intern();
    public static final String EXO_HIDDENABLE = "exo:hiddenable".intern();
    public static final String NT_FILE = "nt:file".intern();
    public static final String NT_FOLDER = "nt:folder".intern();
    public static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    public static final String DOCUMENT_TYPE = "file".intern();
    public static final String IMAGE_TYPE = "image".intern();
    public static final String FLASH_TYPE = "flash".intern();
    public static final String LINK_TYPE = "link".intern();

    public static Element createRootElement(String command, Node node, String folderType) throws Exception {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.newDocument();
        String currentPath = node.getPath();
        if (!currentPath.endsWith("/")) {
            currentPath = currentPath + "/";
        }
        Element rootElement = doc.createElement("Connector");
        doc.appendChild(rootElement);
        rootElement.setAttribute("command", command);
        rootElement.setAttribute("resourceType", "Node");
        Element currentFolderElement = doc.createElement("CurrentFolder");
        currentFolderElement.setAttribute("name", node.getName());
        currentFolderElement.setAttribute("folderType", folderType);
        currentFolderElement.setAttribute("path", currentPath);
        currentFolderElement.setAttribute("url", FCKUtils.createWebdavURL(node));
        rootElement.appendChild(currentFolderElement);
        return rootElement;
    }

    public static boolean hasAddNodePermission(Node node) throws Exception {
        try {
            ((ExtendedNode)node).checkPermission("add_node");
            return true;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public static String createWebdavURL(Node node) throws Exception {
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        String currentPath = node.getPath();
        String url = "/" + FCKUtils.getPortalName() + "/" + PortalContainer.getCurrentRestContextName() + "/jcr/" + repository + "/" + workspace + currentPath;
        return url;
    }
}

