/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.PerRequestObjectFactory;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.SingletonObjectFactory;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorValidator;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.uri.UriPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceBinder {
    private static final Log LOG = ExoLogger.getLogger((String)"ws.rest.core.ResourceBinder");
    private static final Comparator<ObjectFactory<AbstractResourceDescriptor>> RESOURCE_COMPARATOR = new ResourceComparator();
    private final List<ObjectFactory<AbstractResourceDescriptor>> rootResources = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
    private final ResourceDescriptorVisitor rdv = ResourceDescriptorValidator.getInstance();
    private int size = 0;
    private final RuntimeDelegate rd = new RuntimeDelegateImpl();

    public ResourceBinder(ExoContainerContext containerContext) throws Exception {
        RuntimeDelegate.setInstance((RuntimeDelegate)this.rd);
        ExoContainer container = containerContext.getContainer();
        List al = container.getComponentInstancesOfType(Application.class);
        for (Application a : al) {
            try {
                this.addApplication(a);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed add JAX-RS application " + a.getClass().getName()), (Throwable)e);
            }
        }
        for (Object resource : container.getComponentInstancesOfType(ResourceContainer.class)) {
            this.bind(resource);
        }
    }

    public void addApplication(Application application) {
        ProviderBinder providers = ProviderBinder.getInstance();
        for (Object obj : application.getSingletons()) {
            if (obj.getClass().getAnnotation(Provider.class) != null) {
                if (obj instanceof ContextResolver) {
                    providers.addContextResolver((ContextResolver)obj);
                }
                if (obj instanceof ExceptionMapper) {
                    providers.addExceptionMapper((ExceptionMapper)obj);
                }
                if (obj instanceof MessageBodyReader) {
                    providers.addMessageBodyReader((MessageBodyReader)obj);
                }
                if (!(obj instanceof MessageBodyWriter)) continue;
                providers.addMessageBodyWriter((MessageBodyWriter)obj);
                continue;
            }
            if (obj.getClass().getAnnotation(Filter.class) != null) {
                if (obj instanceof MethodInvokerFilter) {
                    providers.addMethodInvokerFilter((MethodInvokerFilter)obj);
                }
                if (obj instanceof RequestFilter) {
                    providers.addRequestFilter((RequestFilter)obj);
                }
                if (!(obj instanceof ResponseFilter)) continue;
                providers.addResponseFilter((ResponseFilter)obj);
                continue;
            }
            this.bind(obj);
        }
        for (Class clazz : application.getClasses()) {
            if (clazz.getAnnotation(Provider.class) != null) {
                if (ContextResolver.class.isAssignableFrom(clazz)) {
                    providers.addContextResolver(clazz);
                }
                if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                    providers.addExceptionMapper(clazz);
                }
                if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                    providers.addMessageBodyReader(clazz);
                }
                if (!MessageBodyWriter.class.isAssignableFrom(clazz)) continue;
                providers.addMessageBodyWriter(clazz);
                continue;
            }
            if (clazz.getAnnotation(Filter.class) != null) {
                if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                    providers.addMethodInvokerFilter(clazz);
                }
                if (RequestFilter.class.isAssignableFrom(clazz)) {
                    providers.addRequestFilter(clazz);
                }
                if (!ResponseFilter.class.isAssignableFrom(clazz)) continue;
                providers.addResponseFilter(clazz);
                continue;
            }
            this.bind(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(Object resource) {
        Path path = resource.getClass().getAnnotation(Path.class);
        AbstractResourceDescriptorImpl descriptor = null;
        if (path != null) {
            try {
                descriptor = new AbstractResourceDescriptorImpl(resource);
            }
            catch (Exception e) {
                String msg = "Unexpected error occurs when process resource class " + resource.getClass().getName();
                LOG.error((Object)msg, (Throwable)e);
                return false;
            }
        } else {
            String msg = "Resource class " + resource.getClass().getName() + " it is not root resource. " + "Path annotation javax.ws.rs.Path is not specified for this class.";
            LOG.warn((Object)msg);
            return false;
        }
        try {
            descriptor.accept(this.rdv);
        }
        catch (Exception e) {
            LOG.error((Object)"Validation of root resource failed. ", (Throwable)e);
            return false;
        }
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            for (ObjectFactory<AbstractResourceDescriptor> exist : this.rootResources) {
                if (!exist.getObjectModel().getUriPattern().equals(descriptor.getUriPattern())) continue;
                String msg = "Resource class " + descriptor.getObjectClass().getName() + " can't be registered. Resource class " + exist.getClass().getName() + " with the same pattern " + exist.getObjectModel().getUriPattern().getTemplate() + " already registered.";
                LOG.warn((Object)msg);
                return false;
            }
            SingletonObjectFactory<AbstractResourceDescriptorImpl> res = new SingletonObjectFactory<AbstractResourceDescriptorImpl>(descriptor, resource);
            this.rootResources.add(res);
            Collections.sort(this.rootResources, RESOURCE_COMPARATOR);
            LOG.info((Object)("Bind new resource " + ((AbstractResourceDescriptor)res.getObjectModel()).getUriPattern().getTemplate() + " : " + descriptor.getObjectClass()));
        }
        ++this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(Class<?> resourceClass) {
        Path path = resourceClass.getAnnotation(Path.class);
        AbstractResourceDescriptorImpl descriptor = null;
        if (path != null) {
            try {
                descriptor = new AbstractResourceDescriptorImpl(resourceClass);
            }
            catch (Exception e) {
                String msg = "Unexpected error occurs when process resource class " + resourceClass.getName();
                LOG.error((Object)msg, (Throwable)e);
                return false;
            }
        } else {
            String msg = "Resource class " + resourceClass.getName() + " it is not root resource. " + "Path annotation javax.ws.rs.Path is not specified for this class.";
            LOG.warn((Object)msg);
            return false;
        }
        try {
            descriptor.accept(this.rdv);
        }
        catch (Exception e) {
            LOG.error((Object)"Validation of root resource failed. ", (Throwable)e);
            return false;
        }
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            for (ObjectFactory<AbstractResourceDescriptor> exist : this.rootResources) {
                AbstractResourceDescriptor existDescriptor = exist.getObjectModel();
                if (!exist.getObjectModel().getUriPattern().equals(descriptor.getUriPattern())) continue;
                String msg = "Resource class " + descriptor.getObjectClass().getName() + " can't be registered. Resource class " + existDescriptor.getObjectClass().getName() + " with the same pattern " + exist.getObjectModel().getUriPattern().getTemplate() + " already registered.";
                LOG.warn((Object)msg);
                return false;
            }
            PerRequestObjectFactory<AbstractResourceDescriptorImpl> res = new PerRequestObjectFactory<AbstractResourceDescriptorImpl>(descriptor);
            this.rootResources.add(res);
            Collections.sort(this.rootResources, RESOURCE_COMPARATOR);
            LOG.info((Object)("Bind new resource " + ((AbstractResourceDescriptor)res.getObjectModel()).getUriPattern().getRegex() + " : " + resourceClass));
        }
        ++this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(Class clazz) {
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            Iterator<ObjectFactory<AbstractResourceDescriptor>> i = this.rootResources.iterator();
            while (i.hasNext()) {
                ObjectFactory<AbstractResourceDescriptor> res = i.next();
                Class<?> c = res.getObjectModel().getObjectClass();
                if (!clazz.equals(c)) continue;
                i.remove();
                LOG.info((Object)("Remove ResourceContainer " + res.getObjectModel().getUriPattern().getTemplate() + " : " + c));
                --this.size;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(String uriTemplate) {
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            Iterator<ObjectFactory<AbstractResourceDescriptor>> i = this.rootResources.iterator();
            while (i.hasNext()) {
                ObjectFactory<AbstractResourceDescriptor> res = i.next();
                String t = res.getObjectModel().getUriPattern().getTemplate();
                if (!t.equals(uriTemplate)) continue;
                i.remove();
                LOG.info((Object)("Remove ResourceContainer " + res.getObjectModel().getUriPattern().getTemplate()));
                --this.size;
                return true;
            }
            return false;
        }
    }

    public void clear() {
        this.rootResources.clear();
        this.size = 0;
    }

    public List<ObjectFactory<AbstractResourceDescriptor>> getResources() {
        return this.rootResources;
    }

    public int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<AbstractResourceDescriptor> getRootResources() {
        ArrayList<AbstractResourceDescriptor> l = new ArrayList<AbstractResourceDescriptor>(this.rootResources.size());
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            for (ObjectFactory<AbstractResourceDescriptor> f : this.rootResources) {
                l.add(f.getObjectModel());
            }
        }
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResourceComparator
    implements Comparator<ObjectFactory<AbstractResourceDescriptor>> {
        private ResourceComparator() {
        }

        @Override
        public int compare(ObjectFactory<AbstractResourceDescriptor> o1, ObjectFactory<AbstractResourceDescriptor> o2) {
            return UriPattern.URIPATTERN_COMPARATOR.compare(o1.getObjectModel().getUriPattern(), o2.getObjectModel().getUriPattern());
        }
    }
}

