/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.ResourceBundleService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String WORKSPACE_NAME = "workspace".intern();
    public static final String JCR_PATH = "path".intern();
    public static final String DRIVE_FOLDER = "allowCreateFolder".intern();
    public static final String MIN_WIDTH = "minwidth".intern();
    public static final String CB_DOCUMENT_NAME = "documentName".intern();
    public static final String CB_SCRIPT_NAME = "scriptName".intern();
    public static final String CB_REF_DOCUMENT = "reference".intern();
    public static final String CB_CHILD_DOCUMENT = "child".intern();
    public static final String CB_NB_PER_PAGE = "nbPerPage".intern();
    public static final String CB_QUERY_STATEMENT = "queryStatement".intern();
    public static final String CB_QUERY_ISNEW = "isAddNew".intern();
    public static final String CB_QUERY_TYPE = "queryType".intern();
    public static final String CB_QUERY_STORE = "queryStore".intern();
    public static final String CB_QUERY_LANGUAGE = "queryLanguage".intern();
    public static final String CB_VIEW_TOOLBAR = "viewToolbar".intern();
    public static final String CB_VIEW_TAGMAP = "viewTagMap".intern();
    public static final String CB_VIEW_COMMENT = "viewComment".intern();
    public static final String CB_VIEW_VOTE = "viewVote".intern();
    public static final String CB_SEARCH_LOCATION = "searchLocation".intern();
    public static final String CB_ENABLE_SEARCH_LOCATION = "enableSearch".intern();
    public static final String CB_FILTER_CATEGORY = "filterCategory".intern();
    public static final String EXO_AUDITABLE = "exo:auditable";
    public static final String CB_BOX_TEMPLATE = "boxTemplate".intern();
    public static final String CB_TEMPLATE = "template";
    public static final String CB_USECASE = "usecase".intern();
    public static final String CB_ALLOW_PUBLISH = "isAllowPublish".intern();
    public static final String FROM_PATH = "From Path".intern();
    public static final String USE_DOCUMENT = "Document".intern();
    public static final String USE_JCR_QUERY = "Using a JCR query".intern();
    public static final String USE_SCRIPT = "Using a script".intern();
    public static final String CB_USE_FROM_PATH = "path".intern();
    public static final String CB_USE_DOCUMENT = "detail-document".intern();
    public static final String CB_USE_JCR_QUERY = "query".intern();
    public static final String CB_USE_SCRIPT = "script".intern();
    public static final String SEMI_COLON = ";".intern();
    public static final String COLON = ":".intern();
    public static final String SLASH = "/".intern();
    public static final String BACKSLASH = "\\".intern();
    public static final String EXO_CREATED_DATE = "exo:dateCreated";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFIED_DATE = "exo:dateModified";
    public static final String EXO_OWNER = "exo:owner";
    public static final String[] SPECIALCHARACTER = new String[]{SEMI_COLON, COLON, SLASH, BACKSLASH, "'", "|", ">", "<", "\"", "?", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "[", "]", "{", "}"};
    public static final String REPOSITORY = "repository".intern();
    public static final String VIEWS = "views".intern();
    public static final String DRIVE = "drive".intern();
    public static final String TRASH_HOME_NODE_PATH = "trashHomeNodePath".intern();
    public static final String TRASH_REPOSITORY = "trashRepository".intern();
    public static final String TRASH_WORKSPACE = "trashWorkspace".intern();
    public static final String JCR_INFO = "jcrInfo";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FILE = "nt:file";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FROZEN = "nt:frozenNode".intern();
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_RELATION = "exo:relation";
    public static final String EXO_TAXANOMY = "exo:taxonomy";
    public static final String EXO_IMAGE = "exo:image";
    public static final String EXO_ARTICLE = "exo:article";
    public static final String EXO_LANGUAGE = "exo:language";
    public static final String LANGUAGES = "languages";
    public static final String EXO_METADATA = "exo:metadata";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_BASE = "nt:base";
    public static final String DEFAULT = "default";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_FROZEN = "jcr:frozenNode";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_SCORE = "jcr:score";
    public static final String EXO_ROLES = "exo:roles";
    public static final String EXO_TEMPLATEFILE = "exo:templateFile";
    public static final String EXO_TEMPLATE = "exo:template";
    public static final String EXO_ACTION = "exo:action";
    public static final String EXO_ACTIONS = "exo:actions";
    public static final String MIX_LOCKABLE = "mix:lockable";
    public static final String EXO_CATEGORIZED = "exo:categorized";
    public static final String EXO_CATEGORY = "exo:category";
    public static final String EXO_HIDDENABLE = "exo:hiddenable";
    public static final String EXO_ACCESSPERMISSION = "exo:accessPermissions";
    public static final String EXO_PERMISSIONS = "exo:permissions";
    public static final String EXO_FAVOURITE = "exo:favourite";
    public static final String EXO_FAVOURITE_FOLDER = "exo:favoriteFolder";
    public static final String EXO_FAVOURITER = "exo:favouriter";
    public static final String EXO_RESTOREPATH = "exo:restorePath";
    public static final String EXO_RESTORELOCATION = "exo:restoreLocation";
    public static final String EXO_RESTORE_WORKSPACE = "exo:restoreWorkspace";
    public static final String EXO_LASTMODIFIER = "exo:lastModifier";
    public static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    public static final String EXO_TOTAL = "exo:total";
    public static final String EXO_WEBCONTENT = "exo:webContent";
    public static final String EXO_RSS_ENABLE = "exo:rss-enable";
    public static final String EXO_MUSICFOLDER = "exo:musicFolder";
    public static final String EXO_VIDEOFOLDER = "exo:videoFolder";
    public static final String EXO_PICTUREFOLDER = "exo:pictureFolder";
    public static final String EXO_DOCUMENTFOLDER = "exo:documentFolder";
    public static final String EXO_SEARCHFOLDER = "exo:searchFolder";
    public static final String MIX_COMMENTABLE = "mix:commentable";
    public static final String MIX_VOTABLE = "mix:votable";
    public static final String RMA_RECORD = "rma:record";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String EXO_PRIMARYTYPE = "exo:primaryType";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};
    public static final String[] FOLDERS = new String[]{"nt:unstructured", "nt:folder"};
    public static final String[] NON_EDITABLE_NODETYPES = new String[]{"nt:unstructured", "nt:folder", "nt:resource"};
    public static final String[] CATEGORY_NODE_TYPES = new String[]{"nt:folder", "nt:unstructured", "exo:taxonomy"};
    public static final String CATEGORY_MANDATORY = "categoryMandatoryWhenFileUpload";
    public static final String UPLOAD_SIZE_LIMIT_MB = "uploadFileSizeLimitMB";
    public static final String FILE_VIEWER_EXTENSION_TYPE = "org.exoplatform.ecm.dms.FileViewer";
    public static final String MIME_TYPE = "mimeType";
    public static final String LOCALE_WEBUI_DMS = "locale.portlet.i18n.WebUIDms";
    public static final String REQUESTCONTEXT = "requestcontext";
    public static final String WORKSPACE_PARAM = "workspaceName";
    public static final String EMPTY = "";
    public static final String PUBLIC = "Public";
    public static final String GROUP = "Group";
    public static final String SITE = "Site";
    public static final String PRIVATE = "Private";
    private static final Log LOG = ExoLogger.getLogger((String)"webui.Utils");
    public Map<String, Object> maps_ = new HashMap<String, Object>();

    public static String encodeHTML(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String formatNodeName(String text) {
        return text.replaceAll("'", "\\\\'");
    }

    public static boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType(MIX_VERSIONABLE);
    }

    public static boolean isTrashHomeNode(Node node) throws RepositoryException {
        return node.isNodeType(EXO_TRASH_FOLDER);
    }

    public static boolean isNameValid(String name, String[] regexpression) {
        for (String c : regexpression) {
            if (!name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameEmpty(String name) {
        return name == null || name.trim().length() == 0;
    }

    public static boolean isAuditable(Node node) throws RepositoryException {
        return node.isNodeType(EXO_AUDITABLE);
    }

    public static String getIndexName(Node node) throws RepositoryException {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(node.getName());
        int index = node.getIndex();
        if (index > 1) {
            buffer.append('[');
            buffer.append(index);
            buffer.append(']');
        }
        return buffer.toString();
    }

    public static List<String> getListAllowedFileType(Node currentNode, String repository, TemplateService templateService) throws Exception {
        ArrayList<String> nodeTypes = new ArrayList<String>();
        NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
        NodeType currentNodeType = currentNode.getPrimaryNodeType();
        NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
        List templates = templateService.getDocumentTemplates(repository);
        try {
            block2: for (int i = 0; i < templates.size(); ++i) {
                String nodeTypeName = ((String)templates.get(i)).toString();
                NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                NodeType[] superTypes = nodeType.getSupertypes();
                boolean isCanCreateDocument = false;
                for (NodeDefinition nodeDefinition : childDefs) {
                    NodeType[] requiredChilds;
                    for (NodeType requiredChild : requiredChilds = nodeDefinition.getRequiredPrimaryTypes()) {
                        if (!nodeTypeName.equals(requiredChild.getName())) continue;
                        isCanCreateDocument = true;
                        break;
                    }
                    if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                    if (!nodeTypes.contains(nodeTypeName)) {
                        nodeTypes.add(nodeTypeName);
                    }
                    isCanCreateDocument = true;
                }
                if (isCanCreateDocument) continue;
                for (NodeDefinition nodeDefinition : superTypes) {
                    for (NodeDefinition childDef : childDefs) {
                        for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                            if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                            if (!nodeTypes.contains(nodeTypeName)) {
                                nodeTypes.add(nodeTypeName);
                            }
                            isCanCreateDocument = true;
                            break;
                        }
                        if (isCanCreateDocument) break;
                    }
                    if (isCanCreateDocument) continue block2;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return nodeTypes;
    }

    public static String getNodeTypeIcon(Node node, String appended, String mode) throws RepositoryException {
        StringBuilder str = new StringBuilder();
        if (node == null) {
            return EMPTY;
        }
        String nodeType = node.getPrimaryNodeType().getName();
        if (node.isNodeType(EXO_SYMLINK)) {
            LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
            try {
                nodeType = node.getProperty(EXO_PRIMARYTYPE).getString();
                node = linkManager.getTarget(node);
                if (node == null) {
                    return EMPTY;
                }
            }
            catch (Exception e) {
                return EMPTY;
            }
        }
        if (node.isNodeType(EXO_TRASH_FOLDER)) {
            nodeType = EXO_TRASH_FOLDER;
        }
        if (node.isNodeType(EXO_FAVOURITE_FOLDER)) {
            nodeType = EXO_FAVOURITE_FOLDER;
        }
        if (nodeType.equals(NT_UNSTRUCTURED) || nodeType.equals(NT_FOLDER)) {
            for (String specificFolder : SPECIFIC_FOLDERS) {
                if (!node.isNodeType(specificFolder)) continue;
                nodeType = specificFolder;
                break;
            }
        }
        nodeType = nodeType.replace(':', '_') + appended;
        str.append(nodeType);
        str.append(" ");
        str.append("default16x16Icon");
        if (mode != null && mode.equalsIgnoreCase("Collapse")) {
            str.append(' ').append(mode).append(nodeType);
        }
        if (node.isNodeType(NT_FILE) && node.hasNode(JCR_CONTENT)) {
            Node jcrContentNode = node.getNode(JCR_CONTENT);
            str.append(' ').append(jcrContentNode.getProperty(JCR_MIMETYPE).getString().replaceAll("/|\\.", "_")).append(appended);
        }
        return str.toString();
    }

    public static String getNodeTypeIcon(Node node, String appended) throws RepositoryException {
        return Utils.getNodeTypeIcon(node, appended, null);
    }

    public static NodeIterator getAuthorizedChildNodes(Node node) throws Exception {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            if (PermissionUtil.canRead(iter.nextNode())) continue;
            iter.remove();
        }
        return iter;
    }

    public static List<Node> getAuthorizedChildList(Node node) throws Exception {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!PermissionUtil.canRead(child)) continue;
            children.add(child);
        }
        return children;
    }

    public static boolean isLockTokenHolder(Node node) throws Exception {
        return node.getLock().getLockToken() != null;
    }

    public static List<String> getMemberships() throws Exception {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService oservice = (OrganizationService)Util.getUIPortal().getApplicationComponent(OrganizationService.class);
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection memberships = oservice.getMembershipHandler().findMembershipsByUser(userId);
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Membership membership = (Membership)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroupId();
            userMemberships.add(role);
        }
        return userMemberships;
    }

    public static List<String> getGroups() throws Exception {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService oservice = (OrganizationService)Util.getUIPortal().getApplicationComponent(OrganizationService.class);
        ArrayList<String> groupList = new ArrayList<String>();
        Collection groups = oservice.getGroupHandler().findGroupsOfUser(userId);
        Object[] objects = groups.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Group group = (Group)objects[i];
            String groupPath = null;
            groupPath = group.getParentId() == null || group.getParentId().length() == 0 ? "/" + group.getGroupName() : group.getParentId() + "/" + group.getGroupName();
            groupList.add(groupPath);
        }
        return groupList;
    }

    public static String getNodeOwner(Node node) throws Exception {
        try {
            if (node.hasProperty(EXO_OWNER)) {
                return node.getProperty(EXO_OWNER).getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Node findNodeByUUID(String repository, String uuid) throws Exception {
        RepositoryService repositoryService = (RepositoryService)Util.getUIPortal().getApplicationComponent(RepositoryService.class);
        SessionProviderService sessionProviderService = (SessionProviderService)Util.getUIPortal().getApplicationComponent(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        Node node = null;
        for (String wsName : manageableRepository.getWorkspaceNames()) {
            try {
                node = sessionProvider.getSession(wsName, manageableRepository).getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return node;
    }

    public static boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public static Node getNodeSymLink(Node node) throws Exception {
        LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
        Node realNode = null;
        if (linkManager.isLink((Item)node)) {
            if (linkManager.isTargetReachable(node)) {
                realNode = linkManager.getTarget(node);
            }
        } else {
            realNode = node;
        }
        return realNode;
    }

    public static InputStream extractFirstEntryFromZipFile(ZipInputStream zipStream) throws Exception {
        return zipStream.getNextEntry() == null ? null : zipStream;
    }

    public static String getThumbnailImage(Node node, String propertyName) throws Exception {
        Node thumbnailNode;
        String mimeType;
        ThumbnailService thumbnailService = (ThumbnailService)Util.getUIPortal().getApplicationComponent(ThumbnailService.class);
        if (node.getPrimaryNodeType().getName().equals(NT_FILE) && (mimeType = node.getNode(JCR_CONTENT).getProperty(JCR_MIMETYPE).getString()).startsWith("image")) {
            Node thumbnailNode2 = thumbnailService.addThumbnailNode(node);
            InputStream inputStream = node.getNode(JCR_CONTENT).getProperty(JCR_DATA).getStream();
            thumbnailService.createSpecifiedThumbnail(thumbnailNode2, ImageIO.read(inputStream), propertyName);
        }
        if ((thumbnailNode = thumbnailService.getThumbnailNode(node)) != null && thumbnailNode.hasProperty(propertyName)) {
            DownloadService dservice = (DownloadService)Util.getUIPortal().getApplicationComponent(DownloadService.class);
            InputStream input = thumbnailNode.getProperty(propertyName).getStream();
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
            dresource.setDownloadName(node.getName());
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public static String calculateFileSize(double fileLengthLong) {
        int fileLengthDigitCount = Double.toString(fileLengthLong).length();
        double fileSizeKB = 0.0;
        String howBig = EMPTY;
        if (fileLengthDigitCount < 5) {
            fileSizeKB = Math.abs(fileLengthLong);
            howBig = "Byte(s)";
        } else if (fileLengthDigitCount >= 5 && fileLengthDigitCount <= 6) {
            fileSizeKB = Math.abs(fileLengthLong / 1024.0);
            howBig = "KB";
        } else if (fileLengthDigitCount >= 7 && fileLengthDigitCount <= 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1048576.0);
            howBig = "MB";
        } else if (fileLengthDigitCount > 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1.073741824E9);
            howBig = "GB";
        }
        String finalResult = Utils.getRoundedValue(fileSizeKB);
        return finalResult + " " + howBig;
    }

    private static String getRoundedValue(double decimalVal) {
        long beforeDecimalValue = Utils.decimalTokenize(decimalVal, 1);
        long afterDecimalValue = Utils.decimalTokenize(decimalVal, 2);
        long decimalValueLength = String.valueOf(afterDecimalValue).length();
        long dividerVal = Utils.divider(decimalValueLength - 1L);
        long dividedValue = afterDecimalValue / dividerVal;
        String finalResult = String.valueOf(beforeDecimalValue) + "." + String.valueOf(dividedValue);
        return finalResult;
    }

    private static long divider(long argLength) {
        long varDivider = 1L;
        int i = 0;
        while ((long)i < argLength - 1L) {
            varDivider *= 10L;
            ++i;
        }
        return varDivider;
    }

    private static long decimalTokenize(double decimalVal, int position) {
        long returnDecimalVal = 0L;
        String strDecimalVal = EMPTY;
        if (decimalVal > 0.0) {
            strDecimalVal = String.valueOf(decimalVal);
        }
        if (strDecimalVal.length() > 0) {
            StringTokenizer decimalToken = new StringTokenizer(strDecimalVal, ".");
            if (position == 1) {
                returnDecimalVal = Long.parseLong(decimalToken.nextToken());
            } else if (position == 2) {
                decimalToken.nextToken();
                returnDecimalVal = Long.parseLong(decimalToken.nextToken());
            }
        }
        return returnDecimalVal;
    }

    public static String getResourceBundle(String key) throws MissingResourceException {
        PortalRequestContext context = Util.getPortalRequestContext();
        ResourceBundle res = context.getApplicationResourceBundle();
        return res.getString(key);
    }

    public static String getResourceBundle(String name, String key, ClassLoader cl) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(name, locale, cl);
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public static String getRestContextName(String portalContainerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        return portalContainerConfig.getRestContextName(portalContainerName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeTypeNameComparator
    implements Comparator<NodeType> {
        @Override
        public int compare(NodeType n1, NodeType n2) throws ClassCastException {
            String name1 = n1.getName();
            String name2 = n2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

