/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PDFDocumentReader
extends BaseDocumentReader {
    protected static Log log = ExoLogger.getLogger((String)"platform.PDFDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"application/pdf"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        PDDocument pdDocument = null;
        StringWriter sw = new StringWriter();
        try {
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                pdDocument = PDDocument.load((InputStream)is);
            }
            catch (IOException e) {
                throw new DocumentReadException("Can not load PDF document.", e);
            }
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setStartPage(1);
            stripper.setEndPage(Integer.MAX_VALUE);
            stripper.writeText(pdDocument, (Writer)sw);
        }
        finally {
            if (pdDocument != null) {
                try {
                    pdDocument.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return sw.toString();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        Properties props = null;
        PdfReader reader = new PdfReader(is, "".getBytes());
        byte[] metadata = reader.getMetadata();
        if (metadata != null) {
            props = this.getPropertiesFromMetadata(metadata);
        }
        if (props == null) {
            props = this.getPropertiesFromInfo(reader.getInfo());
        }
        reader.close();
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return props;
    }

    protected Properties getPropertiesFromMetadata(byte[] metadata) throws IOException, DocumentReadException {
        Document doc;
        Properties props = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            doc = docBuilder.parse(new ByteArrayInputStream(metadata));
        }
        catch (SAXException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        String version = "";
        NodeList list = doc.getElementsByTagName("pdfaid:conformance");
        if (list != null && list.item(0) != null) {
            version = version + list.item(0).getTextContent() + "-";
        }
        if ((list = doc.getElementsByTagName("pdfaid:part")) != null && list.item(0) != null) {
            version = version + list.item(0).getTextContent();
        }
        if (version.equalsIgnoreCase("A-1")) {
            props = this.getPropsFromPDFAMetadata(doc);
        }
        return props;
    }

    protected Properties getPropertiesFromInfo(HashMap info) throws IOException {
        String modDate;
        String creationDate;
        String subject;
        String author;
        Properties props = new Properties();
        String title = (String)info.get("Title");
        if (title != null) {
            props.put(DCMetaData.TITLE, title);
        }
        if ((author = (String)info.get("Author")) != null) {
            props.put(DCMetaData.CREATOR, author);
        }
        if ((subject = (String)info.get("Subject")) != null) {
            props.put(DCMetaData.SUBJECT, subject);
        }
        if ((creationDate = (String)info.get("CreationDate")) != null) {
            props.put(DCMetaData.DATE, PdfDate.decode((String)creationDate));
        }
        if ((modDate = (String)info.get("ModDate")) != null) {
            props.put(DCMetaData.DATE, PdfDate.decode((String)modDate));
        }
        return props;
    }

    private Properties getPropsFromPDFAMetadata(Document doc) throws IOException, DocumentReadException {
        Properties props = new Properties();
        NodeList list = doc.getElementsByTagName("rdf:li");
        if (list != null && list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getParentNode().getParentNode().getNodeName().equals("dc:title")) {
                    String title = n.getLastChild().getTextContent();
                    props.put(DCMetaData.TITLE, title);
                }
                if (n.getParentNode().getParentNode().getNodeName().equals("dc:creator")) {
                    String author = n.getLastChild().getTextContent();
                    props.put(DCMetaData.CREATOR, author);
                }
                if (!n.getParentNode().getParentNode().getNodeName().equals("dc:description")) continue;
                String description = n.getLastChild().getTextContent();
                props.put(DCMetaData.SUBJECT, description);
            }
        }
        try {
            Node modifyDateNode;
            Calendar c;
            Node creationDateNode;
            list = doc.getElementsByTagName("xmp:CreateDate");
            if (list != null && list.item(0) != null && (creationDateNode = list.item(0).getLastChild()) != null) {
                String creationDate = creationDateNode.getTextContent();
                c = ISO8601.parseEx((String)creationDate);
                props.put(DCMetaData.DATE, c);
            }
            if ((list = doc.getElementsByTagName("xmp:ModifyDate")) != null && list.item(0) != null && (modifyDateNode = list.item(0).getLastChild()) != null) {
                String modifyDate = modifyDateNode.getTextContent();
                c = ISO8601.parseEx((String)modifyDate);
                props.put(DCMetaData.DATE, c);
            }
        }
        catch (ParseException e) {
            throw new DocumentReadException(e.getMessage(), e);
        }
        return props;
    }
}

