/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIAddLanguageContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UILanguageTypeForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageManager;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})
public class UILanguageDialogForm
extends UIDialogForm
implements UIPopupComponent,
UISelectable {
    private boolean isAddNew_ = false;
    private String selectedLanguage_ = null;
    private boolean isDefault_ = false;
    private String documentType_;

    public UILanguageDialogForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void doSelect(String selectField, Object value) {
        this.isUpdateSelect = true;
        UIFormInput formInput = this.getUIInput(selectField);
        if (formInput instanceof UIFormInputBase) {
            ((UIFormInputBase)formInput).setValue((Object)value.toString());
        } else if (formInput instanceof UIFormMultiValueInputSet) {
            UIFormMultiValueInputSet inputSet = (UIFormMultiValueInputSet)formInput;
            UIFormInputBase input = (UIFormInputBase)inputSet.getChild(inputSet.getChildren().size() - 1);
            input.setValue((Object)value.toString());
        }
        UIAddLanguageContainer uiContainer = (UIAddLanguageContainer)this.getParent();
        uiContainer.removeChildById("PopupComponent");
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public String getTemplate() {
        this.repositoryName = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.documentType_, userName, this.repositoryName);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.documentType_};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public boolean isAddNew() {
        return this.isAddNew_;
    }

    public void addNew(boolean b) {
        this.isAddNew_ = b;
    }

    public void setIsAddNew(boolean isAddNew) {
        this.isAddNew_ = isAddNew;
    }

    public boolean isEditing() {
        return !this.isAddNew_;
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public void setSelectedLanguage(String selectedLanguage) {
        this.selectedLanguage_ = selectedLanguage;
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage_;
    }

    public void setIsDefaultLanguage(boolean isDefault) {
        this.isDefault_ = isDefault;
    }

    public boolean isDefaultLanguage() {
        return this.isDefault_;
    }

    private boolean hasNodeTypeNTResource(Node node) throws Exception {
        if (node.hasNodes()) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                if (!childNode.getPrimaryNodeType().getName().equals("nt:resource")) continue;
                return true;
            }
        }
        return false;
    }

    private String getDMSWorkspace() {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        return dmsConfiguration.getConfig(this.repositoryName).getSystemWorkspace();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UILanguageDialogForm> {
        public void execute(Event<UILanguageDialogForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UILanguageDialogForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UILanguageDialogForm> {
        public void execute(Event<UILanguageDialogForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UILanguageDialogForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UILanguageDialogForm> {
        public void execute(Event<UILanguageDialogForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UILanguageDialogForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveReferenceActionListener
    extends EventListener<UILanguageDialogForm> {
        public void execute(Event<UILanguageDialogForm> event) throws Exception {
            UILanguageDialogForm uiForm = (UILanguageDialogForm)((Object)event.getSource());
            uiForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            uiForm.getUIStringInput(fieldName).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowComponentActionListener
    extends EventListener<UILanguageDialogForm> {
        public void execute(Event<UILanguageDialogForm> event) throws Exception {
            UILanguageDialogForm uiForm = (UILanguageDialogForm)((Object)event.getSource());
            UIAddLanguageContainer uiContainer = (UIAddLanguageContainer)uiForm.getAncestorOfType(UIAddLanguageContainer.class);
            UIJCRExplorer explorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            uiForm.isShowingComponent = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            Map fieldPropertiesMap = (Map)uiForm.componentSelectors.get(fieldName);
            String classPath = (String)fieldPropertiesMap.get("selectorClass");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(classPath, true, cl);
            UIComponent uiComp = uiContainer.createUIComponent(clazz, null, null);
            String rootPath = (String)fieldPropertiesMap.get("rootPath");
            String value = (String)uiForm.getUIStringInput(fieldName).getValue();
            String[] arrayTaxonomy = new String[1];
            if (value != null && !value.equals("") && (arrayTaxonomy = value.split(",")).length > 0) {
                if (arrayTaxonomy[0].startsWith("[")) {
                    arrayTaxonomy[0] = arrayTaxonomy[0].substring(1, arrayTaxonomy[0].length());
                }
                if (arrayTaxonomy[arrayTaxonomy.length - 1].endsWith("]")) {
                    arrayTaxonomy[arrayTaxonomy.length - 1] = arrayTaxonomy[arrayTaxonomy.length - 1].substring(0, arrayTaxonomy[arrayTaxonomy.length - 1].length() - 1);
                }
            }
            if (uiComp instanceof UIOneNodePathSelector) {
                String[] arrParams;
                String selectorParams;
                String repositoryName = explorer.getRepositoryName();
                SessionProvider provider = explorer.getSessionProvider();
                String wsFieldName = (String)fieldPropertiesMap.get("workspaceField");
                String wsName = "";
                if (wsFieldName != null && wsFieldName.length() > 0) {
                    wsName = (String)((UIFormInputBase)uiForm.getUIInput(wsFieldName)).getValue();
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                }
                if ((selectorParams = (String)fieldPropertiesMap.get("selectorParams")) != null && (arrParams = selectorParams.split(",")).length == 4) {
                    ((UIOneNodePathSelector)uiComp).setAcceptedNodeTypesInPathPanel(new String[]{"nt:file", "nt:folder", "nt:unstructured", "exo:taxonomy"});
                    wsName = arrParams[1];
                    rootPath = arrParams[2];
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    if (arrParams[3].indexOf(";") > -1) {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(arrParams[3].split(";"));
                    } else {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(new String[]{arrParams[3]});
                    }
                }
                if (rootPath == null) {
                    rootPath = "/";
                }
                ((UIOneNodePathSelector)uiComp).setRootNodeLocation(repositoryName, wsName, rootPath);
                ((UIOneNodePathSelector)uiComp).setShowRootPathSelect(true);
                ((UIOneNodePathSelector)uiComp).init(provider);
            } else if (uiComp instanceof UIOneTaxonomySelector) {
                String workspaceName = uiForm.getDMSWorkspace();
                ((UIOneTaxonomySelector)uiComp).setIsDisable(workspaceName, false);
                String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
                Session session = explorer.getSessionByWorkspace(workspaceName);
                Node rootTree = (Node)session.getItem(rootTreePath);
                NodeIterator childrenIterator = rootTree.getNodes();
                if (childrenIterator.hasNext()) {
                    Node childNode = childrenIterator.nextNode();
                    rootTreePath = childNode.getPath();
                }
                ((UIOneTaxonomySelector)uiComp).setRootNodeLocation(uiForm.repositoryName, workspaceName, rootTreePath);
                ((UIOneTaxonomySelector)uiComp).setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                ((UIOneTaxonomySelector)uiComp).init(SessionProviderFactory.createSystemProvider());
            }
            uiContainer.initPopup(uiComp);
            String param = "returnField=" + fieldName;
            ((ComponentSelector)uiComp).setSourceComponent((UIComponent)uiForm, new String[]{param});
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UILanguageDialogForm> {
        public void execute(Event<UILanguageDialogForm> event) throws Exception {
            Map map;
            Map inputProperties;
            UILanguageDialogForm uiForm = (UILanguageDialogForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            Node node = uiExplorer.getCurrentNode();
            String nodeTypeName = node.getPrimaryNodeType().getName();
            uiExplorer.addLockToken(node);
            MultiLanguageService multiLanguageService = (MultiLanguageService)uiForm.getApplicationComponent(MultiLanguageService.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (uiForm.selectedLanguage_ == null) {
                uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.select-lang", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!uiExplorer.hasAddPermission()) {
                uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (node.hasNode("exo:image")) {
                inputProperties = DialogFormUtil.prepareMap((List)uiForm.getChildren(), (Map)uiForm.getInputProperties());
                try {
                    multiLanguageService.addLanguage(node, inputProperties, uiForm.getSelectedLanguage(), uiForm.isDefaultLanguage(), "exo:image");
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            if (uiForm.hasNodeTypeNTResource(node)) {
                inputProperties = DialogFormUtil.prepareMap((List)uiForm.getChildren(), (Map)uiForm.getInputProperties());
                try {
                    multiLanguageService.addFileLanguage(node, uiForm.getSelectedLanguage(), inputProperties, uiForm.isDefaultLanguage());
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            if (node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured")) {
                map = DialogFormUtil.prepareMap((List)uiForm.getChildren(), (Map)uiForm.properties);
                try {
                    multiLanguageService.addFolderLanguage(node, map, uiForm.getSelectedLanguage(), uiForm.isDefaultLanguage(), nodeTypeName, uiExplorer.getRepositoryName());
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            map = DialogFormUtil.prepareMap((List)uiForm.getChildren(), (Map)uiForm.properties);
            try {
                multiLanguageService.addLanguage(node, map, uiForm.getSelectedLanguage(), uiForm.isDefaultLanguage());
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            node.save();
            UIMultiLanguageManager uiManager = (UIMultiLanguageManager)uiForm.getAncestorOfType(UIMultiLanguageManager.class);
            UIMultiLanguageForm uiMultiForm = (UIMultiLanguageForm)uiManager.getChild(UIMultiLanguageForm.class);
            uiMultiForm.doSelect(node);
            if (uiForm.isDefaultLanguage()) {
                uiExplorer.setLanguage(uiForm.getSelectedLanguage());
            }
            uiManager.setRenderedChild(UIMultiLanguageForm.class);
            UIAddLanguageContainer uiAddContainer = (UIAddLanguageContainer)uiManager.getChild(UIAddLanguageContainer.class);
            UILanguageTypeForm uiLanguageTypeForm = (UILanguageTypeForm)uiAddContainer.getChild(UILanguageTypeForm.class);
            uiLanguageTypeForm.resetLanguage();
            uiAddContainer.removeChild(UILanguageDialogForm.class);
            uiAddContainer.setComponentDisplay(uiForm.documentType_);
            if (!uiExplorer.getPreference().isJcrEnable()) {
                node.getSession().save();
            }
            uiExplorer.setIsHidePopup(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            uiExplorer.updateAjax(event);
        }
    }
}

