/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIAddMetadataForm;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContainer;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/upload/UIListMetadata.gtmpl", events={@EventConfig(listeners={EditActionListener.class})})
public class UIListMetadata
extends UIContainer {
    public List<String> externalList_ = new ArrayList<String>();
    private boolean isExternalMetadata = false;

    public void setIsExternalMetadata(boolean isExternal) {
        this.isExternalMetadata = isExternal;
    }

    public boolean getIsExternalMetadata() {
        return this.isExternalMetadata;
    }

    public Node getUploadedNode() {
        return ((UIUploadContainer)this.getParent()).getUploadedNode();
    }

    private boolean isInternalUse(NodeType nodeType) throws Exception {
        for (PropertyDefinition pro : nodeType.getPropertyDefinitions()) {
            if (!pro.getName().equals("exo:internalUse")) continue;
            return pro.getDefaultValues()[0].getBoolean();
        }
        return false;
    }

    public List<String> getExternalList() throws Exception {
        NodeType[] mixinTypes;
        for (NodeType nodeType : mixinTypes = this.getUploadedNode().getMixinNodeTypes()) {
            if (nodeType.getName().equals("exo:metadata") && !this.isInternalUse(nodeType) && !this.externalList_.contains(nodeType.getName())) {
                this.externalList_.add(nodeType.getName());
            }
            for (NodeType superType : nodeType.getSupertypes()) {
                if (!superType.getName().equals("exo:metadata") || this.isInternalUse(nodeType) || this.externalList_.contains(nodeType.getName())) continue;
                this.externalList_.add(nodeType.getName());
            }
        }
        if (this.getUploadedNode().hasNode("jcr:content")) {
            for (NodeType nodeType : this.getUploadedNode().getNode("jcr:content").getMixinNodeTypes()) {
                if (!nodeType.isNodeType("exo:metadata") || this.isInternalUse(nodeType) || this.externalList_.contains(nodeType.getName())) continue;
                this.externalList_.add(nodeType.getName());
            }
        }
        return this.externalList_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIListMetadata> {
        public void execute(Event<UIListMetadata> event) throws Exception {
            UIListMetadata uiUploadContent = (UIListMetadata)((Object)event.getSource());
            UIUploadContainer uiUploadContainer = (UIUploadContainer)uiUploadContent.getParent();
            MetadataService metadataService = (MetadataService)uiUploadContent.getApplicationComponent(MetadataService.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiUploadContent.getAncestorOfType(UIJCRExplorer.class);
            String repository = uiExplorer.getRepositoryName();
            String nodeType = event.getRequestContext().getRequestParameter("objectId");
            String template = metadataService.getMetadataTemplate(nodeType, true, repository);
            if (template == null || template.trim().length() == 0) {
                UIApplication uiApp = (UIApplication)uiUploadContent.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{nodeType};
                uiApp.addMessage(new ApplicationMessage("UIUploadContent.msg.has-not-template", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiUploadContainer.removeChild(UIAddMetadataForm.class);
            UIAddMetadataForm uiAddMetadataForm = (UIAddMetadataForm)uiUploadContainer.createUIComponent(UIAddMetadataForm.class, null, null);
            uiAddMetadataForm.getChildren().clear();
            uiAddMetadataForm.setNodeType(nodeType);
            uiAddMetadataForm.setIsNotEditNode(true);
            Node currentNode = uiExplorer.getCurrentNode();
            uiAddMetadataForm.setWorkspace(currentNode.getSession().getWorkspace().getName());
            uiAddMetadataForm.setStoredPath(currentNode.getPath());
            uiAddMetadataForm.setChildPath(uiUploadContainer.getEditNode(nodeType).getPath());
            uiUploadContainer.addChild((UIComponent)uiAddMetadataForm);
            uiUploadContainer.setRenderedChild(UIAddMetadataForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadContainer);
        }
    }
}

