/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction.impl.jotm;

import java.rmi.RemoteException;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.transaction.ExoResource;
import org.exoplatform.services.transaction.TransactionService;
import org.exoplatform.services.transaction.impl.jotm.ResourceEntry;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionFactoryImpl;
import org.objectweb.jotm.XidImpl;
import org.objectweb.transaction.jta.ResourceManagerEvent;

public class TransactionServiceJotmImpl
implements TransactionService {
    protected static Log log = ExoLogger.getLogger((String)"transaction.TransactionServiceJotmImpl");
    public static final String TRACK_WITHOT_TRANSACTION_PARAM = "track-without-transaction";
    private boolean trackWithoutTransaction = false;
    private Current current = Current.getCurrent();

    public TransactionServiceJotmImpl(InitialContextInitializer initializer, InitParams params) throws RemoteException {
        if (this.current == null) {
            TransactionFactoryImpl tm = new TransactionFactoryImpl();
            this.current = new Current((TransactionFactory)tm);
            if (params != null) {
                if (params.getValueParam("timeout") != null) {
                    int t = Integer.parseInt(params.getValueParam("timeout").getValue());
                    this.current.setDefaultTimeout(t);
                }
                if (params.getValueParam(TRACK_WITHOT_TRANSACTION_PARAM) != null) {
                    this.trackWithoutTransaction = Boolean.parseBoolean(params.getValueParam(TRACK_WITHOT_TRANSACTION_PARAM).getValue());
                }
            }
        } else {
            log.info((Object)("Use externally initialized JOTM: " + this.current));
        }
    }

    public TransactionManager getTransactionManager() {
        return this.current;
    }

    public UserTransaction getUserTransaction() {
        return this.current;
    }

    public void enlistResource(ExoResource exores) throws RollbackException, SystemException {
        XAResource xares = exores.getXAResource();
        ResourceEntry entry = new ResourceEntry(exores);
        exores.setPayload(entry);
        Transaction tx = this.getTransactionManager().getTransaction();
        if (tx != null) {
            this.current.getTransaction().enlistResource(xares);
        } else if (this.trackWithoutTransaction) {
            this.current.connectionOpened((ResourceManagerEvent)entry);
            entry.jotmResourceList = this.popThreadLocalRMEventList();
            this.pushThreadLocalRMEventList(entry.jotmResourceList);
        }
    }

    public void delistResource(ExoResource exores) throws RollbackException, SystemException {
        XAResource xares = exores.getXAResource();
        ResourceEntry entry = (ResourceEntry)exores.getPayload();
        Transaction tx = this.getTransactionManager().getTransaction();
        if (tx != null) {
            this.current.getTransaction().delistResource(xares, 0);
        } else if (this.trackWithoutTransaction) {
            this.current.connectionClosed((ResourceManagerEvent)entry);
            if (entry != null && entry.jotmResourceList != null) {
                entry.jotmResourceList.remove(xares);
            }
        }
        exores.setPayload(null);
    }

    public Xid createXid() {
        return new XidImpl();
    }

    public int getDefaultTimeout() {
        return this.current.getDefaultTimeout();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.current.setTransactionTimeout(seconds);
    }

    public void pushThreadLocalRMEventList(List eventList) {
        this.current.pushThreadLocalRMEventList(eventList);
    }

    public List popThreadLocalRMEventList() {
        return this.current.popThreadLocalRMEventList();
    }
}

